/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.cyclops.cyclopscore.helper.IBlockEntityHelpers;
import org.jetbrains.annotations.Nullable;

public class BlockEntityHelpersCommon
implements IBlockEntityHelpers {
    private boolean unsafeBlockEntityGetter = false;

    @Override
    public boolean isUnsafeBlockEntityGetter() {
        return this.unsafeBlockEntityGetter;
    }

    @Override
    public void setUnsafeBlockEntityGetter(boolean unsafeBlockEntityGetter) {
        this.unsafeBlockEntityGetter = unsafeBlockEntityGetter;
    }

    @Override
    public <T> Optional<T> get(BlockGetter level, BlockPos pos, Class<T> targetClazz) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = this.isUnsafeBlockEntityGetter() && level instanceof Level && !((Level)level).isClientSide() && Thread.currentThread() != ((Level)level).getServer().getRunningThread() ? this.getLevelBlockEntityUnchecked((Level)level, pos) : level.getBlockEntity(pos);
        if (blockEntity == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(targetClazz.cast(blockEntity));
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    @Nullable
    public BlockEntity getLevelBlockEntityUnchecked(Level level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return null;
        }
        return level.getChunkAt(pos).getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }
}

