/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.render.model;

import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class RenderModel<T extends Entity, M extends Model>
extends EntityRenderer<T> {
    private ResourceLocation texture;
    protected M model;

    public RenderModel(EntityRendererProvider.Context renderContext, ExtendedConfigCommon<?, ?, ModBase<?>> config) {
        super(renderContext);
        this.texture = this.createResourceLocation(config);
        this.model = this.constructModel();
    }

    protected ResourceLocation createResourceLocation(ExtendedConfigCommon<?, ?, ModBase<?>> config) {
        return ResourceLocation.fromNamespaceAndPath((String)config.getMod().getModId(), (String)(config.getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + config.getNamedId() + ".png"));
    }

    protected abstract M constructModel();

    public ResourceLocation getTextureLocation(Entity entity) {
        return this.texture;
    }
}

