/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class MinimumSizeValidator
implements ISizeValidator {
    private final Vec3i minimumSize;

    public MinimumSizeValidator(Vec3i minimumSize) {
        this.minimumSize = minimumSize;
    }

    @Override
    public Component isSizeValid(Vec3i size) {
        if (SizeValidators.compareVec3i(size, this.getMinimumSize()) >= 0) {
            return null;
        }
        return Component.translatable((String)"multiblock.cyclopscore.error.size.min", (Object[])new Object[]{IModHelpers.get().getLocationHelpers().toCompactString(size.offset(1, 1, 1)), IModHelpers.get().getLocationHelpers().toCompactString(this.getMinimumSize().offset(1, 1, 1))});
    }

    public Vec3i getMinimumSize() {
        return this.minimumSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinimumSizeValidator)) {
            return false;
        }
        MinimumSizeValidator other = (MinimumSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vec3i this$minimumSize = this.getMinimumSize();
        Vec3i other$minimumSize = other.getMinimumSize();
        return !(this$minimumSize == null ? other$minimumSize != null : !this$minimumSize.equals(other$minimumSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinimumSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vec3i $minimumSize = this.getMinimumSize();
        result = result * 59 + ($minimumSize == null ? 43 : $minimumSize.hashCode());
        return result;
    }

    public String toString() {
        return "MinimumSizeValidator(minimumSize=" + String.valueOf(this.getMinimumSize()) + ")";
    }
}

