/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;

public class MaximumBlockCountValidator
implements IBlockCountValidator {
    private final int maximumCount;

    public MaximumBlockCountValidator(int maximumCount) {
        this.maximumCount = maximumCount;
    }

    @Override
    public Component isValid(int count, boolean structureComplete, Block block) {
        if (count <= this.getMaximumCount()) {
            return null;
        }
        return Component.translatable((String)"multiblock.cyclopscore.error.blockCount.max", (Object[])new Object[]{this.getMaximumCount(), Component.translatable((String)block.getDescriptionId()), count});
    }

    public int getMaximumCount() {
        return this.maximumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaximumBlockCountValidator)) {
            return false;
        }
        MaximumBlockCountValidator other = (MaximumBlockCountValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMaximumCount() == other.getMaximumCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaximumBlockCountValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaximumCount();
        return result;
    }

    public String toString() {
        return "MaximumBlockCountValidator(maximumCount=" + this.getMaximumCount() + ")";
    }
}

