/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.item;

import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.zeroregard.ars_technica.registry.DataComponentRegistry;
import com.zeroregard.ars_technica.registry.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;

public class SpyMonocle
extends Item {
    public static final float ZOOM_FOV_MODIFIER = 0.1f;
    public static final float ZOOM_SENSITIVITY_MODIFIER = 0.05f;
    private static final String ZOOM_TAG = "Zoomed";
    private static Double previousSensitivity = null;

    public SpyMonocle(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.ars_technica.spy_monocle.tooltip", (Object[])new Object[]{KeyMapping.createNameSupplier((String)ModKeyBindings.HEAD_CURIO_HOTKEY.getName()).get()}));
        tooltipComponents.add((Component)Component.translatable((String)"ars_technica.create_goggles_info").withStyle(ChatFormatting.GOLD));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        Optional curioSlot;
        if (world.isClientSide && entity instanceof Player && (curioSlot = CuriosApi.getCuriosInventory((LivingEntity)(player = (Player)entity)).flatMap(handler -> handler.findFirstCurio(stack.getItem()))).isPresent()) {
            Minecraft mc = Minecraft.getInstance();
            boolean shouldZoom = ModKeyBindings.HEAD_CURIO_HOTKEY.isDown() && mc.options.getCameraType() == CameraType.FIRST_PERSON && mc.screen == null;
            this.setZoomState(stack, shouldZoom, player);
        }
    }

    private void setZoomState(ItemStack stack, boolean zoomed, Player player) {
        boolean currentlyZoomed = SpyMonocle.isZoomed(stack);
        if (currentlyZoomed != zoomed) {
            DataComponentPatch patch = DataComponentPatch.builder().set((DataComponentType)DataComponentRegistry.ZOOMED.get(), (Object)zoomed).build();
            stack.applyComponents(patch);
            if (zoomed) {
                player.playSound((SoundEvent)SoundRegistry.SPY_MONOCLE_USE.get(), 1.0f, 1.0f);
            } else {
                player.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
            }
            SpyMonocle.adjustMouseSensitivity(player, zoomed);
        }
    }

    public static boolean isZoomed(ItemStack stack) {
        DataComponentMap components = stack.getComponents();
        boolean currentlyZoomed = (Boolean)components.getOrDefault((DataComponentType)DataComponentRegistry.ZOOMED.get(), (Object)false);
        return currentlyZoomed;
    }

    private static void adjustMouseSensitivity(Player player, boolean zooming) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == player) {
            if (zooming) {
                if (previousSensitivity == null) {
                    previousSensitivity = (Double)mc.options.sensitivity().get();
                }
                mc.options.sensitivity().set((Object)(previousSensitivity * (double)0.05f));
            } else if (previousSensitivity != null) {
                mc.options.sensitivity().set((Object)previousSensitivity);
                previousSensitivity = null;
            }
        }
    }

    public static void forceResetZoom(@Nullable Player player) {
        Minecraft mc = Minecraft.getInstance();
        if (previousSensitivity != null && (player == null || mc.player == player)) {
            mc.options.sensitivity().set((Object)previousSensitivity);
            previousSensitivity = null;
        }
    }
}

