/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.helpers;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class RecipeHelpers {
    public static List<ItemStack> rollResultsWithFortuneBoost(ProcessingRecipe recipe, RandomSource random, float chanceMultiplier, boolean allowOverflow) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        List rollables = recipe.getRollableResults();
        for (ProcessingOutput rollable : rollables) {
            ItemStack stack;
            float adjustedChance = rollable.getChance() * chanceMultiplier;
            if (!allowOverflow) {
                adjustedChance = Math.min(1.0f, adjustedChance);
            }
            adjustedChance = Math.max(0.0f, adjustedChance);
            int guaranteedRolls = (int)adjustedChance;
            float partialChance = adjustedChance - (float)guaranteedRolls;
            for (int guaranteed = 0; guaranteed < guaranteedRolls; ++guaranteed) {
                ItemStack guaranteedStack = rollable.getStack().copy();
                if (guaranteedStack.isEmpty()) continue;
                results.add(guaranteedStack);
            }
            if (!(random.nextFloat() < partialChance) || (stack = rollable.getStack().copy()).isEmpty()) continue;
            results.add(stack);
        }
        return results;
    }

    public static boolean isChanceBased(ItemStack input, ProcessingRecipe recipe) {
        List rollables = recipe.getRollableResults();
        return rollables.stream().anyMatch(rollable -> input.getItem() == rollable.getStack().getItem() && rollable.getChance() < 1.0f);
    }

    public static Optional<RecipeHolder<PressingRecipe>> getPressingRecipeForItemStack(ItemStack input, Level world) {
        SingleRecipeInput wrapper = new SingleRecipeInput(input);
        return world.getRecipeManager().getRecipeFor(AllRecipeTypes.PRESSING.getType(), (RecipeInput)wrapper, world);
    }

    public static Optional<AbstractCrushingRecipe> getCrushingRecipeForItemStack(ItemStack input, Level world) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(input);
        Optional recipeHolder = world.getRecipeManager().getRecipeFor(AllRecipeTypes.CRUSHING.getType(), (RecipeInput)recipeInput, world);
        if (recipeHolder.isEmpty()) {
            recipeHolder = world.getRecipeManager().getRecipeFor(AllRecipeTypes.MILLING.getType(), (RecipeInput)recipeInput, world);
        }
        return recipeHolder.map(RecipeHolder::value);
    }

    public static Optional<SplashingRecipe> getSplashingRecipeForItemStack(ItemStack input, Level world) {
        SingleRecipeInput wrapper = new SingleRecipeInput(input);
        Optional recipeHolder = world.getRecipeManager().getRecipeFor(AllRecipeTypes.SPLASHING.getType(), (RecipeInput)wrapper, world);
        return recipeHolder.map(RecipeHolder::value);
    }

    public static Optional<HauntingRecipe> getHauntingRecipeForItemStack(ItemStack input, Level world) {
        SingleRecipeInput wrapper = new SingleRecipeInput(input);
        Optional recipeHolder = world.getRecipeManager().getRecipeFor(AllRecipeTypes.HAUNTING.getType(), (RecipeInput)wrapper, world);
        return recipeHolder.map(RecipeHolder::value);
    }

    public static Optional<RecipeHolder<Recipe<RecipeInput>>> getItemApplicationRecipeForItemStack(ItemStack input, Level world) {
        ItemStackHandler itemHandler = new ItemStackHandler(1);
        itemHandler.setStackInSlot(0, input);
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)itemHandler);
        return world.getRecipeManager().getRecipeFor(AllRecipeTypes.ITEM_APPLICATION.getType(), (RecipeInput)wrapper, world);
    }

    public static Optional<RecipeHolder<ManualApplicationRecipe>> getItemApplicationRecipe(ItemStack applyItem, ItemStack target, Level world) {
        RecipeType type = AllRecipeTypes.ITEM_APPLICATION.getType();
        List allApplicationRecipes = world.getRecipeManager().getAllRecipesFor(type);
        for (RecipeHolder recipeHolder : allApplicationRecipes) {
            ManualApplicationRecipe recipe = (ManualApplicationRecipe)recipeHolder.value();
            ItemStackHandler itemHandler = new ItemStackHandler(2);
            itemHandler.setStackInSlot(0, target);
            itemHandler.setStackInSlot(1, applyItem);
            RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)itemHandler);
            if (!recipe.matches(wrapper, world)) continue;
            return Optional.of(recipeHolder);
        }
        return Optional.empty();
    }

    public static Optional<RecipeHolder<DeployerApplicationRecipe>> getDeployingRecipe(ItemStack applyItem, ItemStack target, Level world) {
        RecipeType type = AllRecipeTypes.DEPLOYING.getType();
        List allDeployingRecipes = world.getRecipeManager().getAllRecipesFor(type);
        for (RecipeHolder recipeHolder : allDeployingRecipes) {
            DeployerApplicationRecipe recipe = (DeployerApplicationRecipe)recipeHolder.value();
            ItemStackHandler itemHandler = new ItemStackHandler(2);
            itemHandler.setStackInSlot(0, target);
            itemHandler.setStackInSlot(1, applyItem);
            RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)itemHandler);
            if (!recipe.matches(wrapper, world)) continue;
            return Optional.of(recipeHolder);
        }
        return Optional.empty();
    }

    public static <R extends ProcessingRecipe<RecipeWrapper, ?>> Optional<RecipeHolder<R>> getSequencedAssemblyRecipe(RecipeType<R> type, Class<R> clazz, ItemStack applyItem, ItemStack target, Level world) {
        ItemStackHandler itemHandler = new ItemStackHandler(2);
        itemHandler.setStackInSlot(0, target);
        itemHandler.setStackInSlot(1, applyItem);
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)itemHandler);
        return SequencedAssemblyRecipe.getRecipe((Level)world, (RecipeInput)wrapper, type, clazz);
    }
}

