/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.entity.ItemProjectileEntity;
import com.zeroregard.ars_technica.helpers.ConsumptionHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EffectTelefeast
extends AbstractEffect {
    public static EffectTelefeast INSTANCE = new EffectTelefeast(ArsTechnica.prefix("glyph_telefeast"), "Telefeast");

    private EffectTelefeast(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getBlockPos();
        BlockEntity be = world.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        BlockState bs = be.getBlockState();
        boolean canUse = spellStats.isSensitive();
        boolean forwardItem = spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE) > 0;
        Direction dir = rayTraceResult.getDirection();
        Vec3 inverseDirection = new Vec3((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ()).scale(-1.0).normalize();
        IFluidHandler fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(world, pos, bs, be, null);
        IItemHandler itemHandler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(world, pos, bs, be, null);
        if (fluidHandler != null) {
            this.handleFluid(shooter, fluidHandler.getFluidInTank(0), fluidHandler, world, inverseDirection, be.getBlockPos(), forwardItem);
        } else if (itemHandler != null) {
            this.handleItem(shooter, itemHandler, world, inverseDirection, be.getBlockPos(), canUse, forwardItem);
        }
    }

    private void handleEntity(LivingEntity caster, Entity target, Level world) {
        if (target instanceof Cow) {
            ItemStack itemResult = new ItemStack((ItemLike)Items.MILK_BUCKET);
            ConsumptionHelper.playSound(SoundEvents.GENERIC_DRINK, world, caster);
            itemResult.finishUsingItem(world, caster);
        }
    }

    private void handleItem(LivingEntity caster, IItemHandler itemHandler, Level world, Vec3 direction, BlockPos position, boolean canUse, boolean forwardItem) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack extractedItem;
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            if (itemStack.isEmpty()) continue;
            if (forwardItem && (ConsumptionHelper.isFood(itemStack, null) || ConsumptionHelper.isDrink(itemStack))) {
                ItemStack emptyContainer;
                extractedItem = itemHandler.extractItem(i, 1, false);
                if (extractedItem.getItem() instanceof PotionFlask) {
                    IPotionProvider data = PotionProviderRegistry.from((ItemStack)extractedItem);
                    if (data != null && data.usesRemaining(extractedItem) > 0) {
                        ItemStack copyItem = extractedItem.copy();
                        IPotionProvider copyData = PotionProviderRegistry.from((ItemStack)copyItem);
                        if (copyData != null) {
                            copyData.setData(data.getPotionData(extractedItem), 1, data.maxUses(extractedItem), copyItem);
                            data.consumeUses(extractedItem, 1, null);
                            itemHandler.insertItem(i, extractedItem, false);
                            this.forwardItem(world, copyItem, direction, position.getCenter());
                            break;
                        }
                    } else {
                        itemHandler.insertItem(i, extractedItem, false);
                        continue;
                    }
                }
                if (!(emptyContainer = this.getEmptyContainer(extractedItem, world)).isEmpty()) {
                    itemHandler.insertItem(i, emptyContainer, false);
                }
                this.forwardItem(world, extractedItem, direction, position.getCenter());
                break;
            }
            if (!canUse && !ConsumptionHelper.isDrink(itemStack) && !ConsumptionHelper.isFood(itemStack, null)) continue;
            extractedItem = itemHandler.extractItem(i, 1, false);
            ItemStack originalItem = extractedItem.copy();
            boolean consumed = false;
            if (ConsumptionHelper.tryUseConsumableItem(caster, extractedItem, world, canUse)) {
                consumed = true;
            } else if (ConsumptionHelper.tryUseEdibleItem(caster, extractedItem, world)) {
                consumed = true;
            }
            if (consumed) {
                if (!extractedItem.isEmpty()) {
                    itemHandler.insertItem(i, extractedItem, false);
                    break;
                }
                ItemStack emptyContainer = this.getEmptyContainer(originalItem, world);
                if (emptyContainer.isEmpty()) break;
                itemHandler.insertItem(i, emptyContainer, false);
                break;
            }
            itemHandler.insertItem(i, extractedItem, false);
        }
    }

    private void handleFluid(LivingEntity caster, FluidStack fluid, IFluidHandler handler, Level world, Vec3 direction, BlockPos position, boolean forwardItem) {
        Optional<FillingResult> bucketRecipe;
        if (fluid.getFluid() == Fluids.LAVA && !forwardItem) {
            Holder.Reference lavaDamageType = world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.LAVA);
            DamageSource lavaDamage = new DamageSource((Holder)lavaDamageType, (Entity)caster, (Entity)caster);
            handler.drain(250, IFluidHandler.FluidAction.EXECUTE);
            caster.hurt(lavaDamage, 50.0f);
            return;
        }
        ItemStack outputItem = null;
        Optional<FillingResult> bottleRecipe = EffectTelefeast.getSpoutFillingRecipe(fluid, new ItemStack((ItemLike)Items.GLASS_BOTTLE), world);
        if (bottleRecipe.isPresent() && handler.getFluidInTank(0).getAmount() >= bottleRecipe.get().fluidAmount) {
            outputItem = bottleRecipe.get().output.copy();
            if (outputItem.getItem() instanceof PotionItem || outputItem.getUseAnimation() == UseAnim.DRINK) {
                handler.drain(bottleRecipe.get().fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            } else {
                outputItem = null;
            }
        }
        if (outputItem == null && (bucketRecipe = EffectTelefeast.getSpoutFillingRecipe(fluid, new ItemStack((ItemLike)Items.BUCKET), world)).isPresent() && handler.getFluidInTank(0).getAmount() >= bucketRecipe.get().fluidAmount) {
            outputItem = bucketRecipe.get().output.copy();
            if (outputItem.getUseAnimation() == UseAnim.DRINK) {
                handler.drain(bucketRecipe.get().fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            } else {
                outputItem = null;
            }
        }
        if (outputItem != null) {
            if (!forwardItem) {
                ConsumptionHelper.tryUseEdibleItem(caster, outputItem, world);
            } else {
                this.forwardItem(world, outputItem, direction, position.getCenter());
            }
        }
    }

    private void forwardItem(Level world, ItemStack item, Vec3 direction, Vec3 position) {
        if (item.isEmpty()) {
            return;
        }
        ItemProjectileEntity projectile = new ItemProjectileEntity(world, position.add(0.0, -0.5, 0.0), direction, item);
        world.addFreshEntity((Entity)projectile);
    }

    private ItemStack getEmptyContainer(ItemStack consumable, Level world) {
        ItemStack containerItem;
        if (consumable.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (consumable.getItem() instanceof PotionItem) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (consumable.getUseAnimation() == UseAnim.DRINK) {
            if (consumable.getItem() == Items.MILK_BUCKET) {
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            containerItem = consumable.getCraftingRemainingItem();
            if (!containerItem.isEmpty()) {
                return containerItem;
            }
        }
        if (ConsumptionHelper.isFood(consumable, null) && !(containerItem = consumable.getCraftingRemainingItem()).isEmpty()) {
            return containerItem;
        }
        String itemName = consumable.getItem().toString().toLowerCase();
        if (itemName.contains("bucket") && !itemName.contains("empty")) {
            return new ItemStack((ItemLike)Items.BUCKET);
        }
        if (itemName.contains("bottle") && !itemName.contains("empty")) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (itemName.contains("bowl") && !itemName.contains("empty")) {
            return new ItemStack((ItemLike)Items.BOWL);
        }
        return ItemStack.EMPTY;
    }

    protected int getDefaultManaCost() {
        return 10;
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return Set.of(AugmentSensitive.INSTANCE, AugmentPierce.INSTANCE);
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentSensitive.INSTANCE, "Will try to 'use' an item even if it's not a drink/food (for example experience gems)");
        map.put((AbstractAugment)AugmentPierce.INSTANCE, "Forwards the consumable in a magic bubble");
    }

    public String getBookDescription() {
        return "Consumes the first edible/potion, or some amount of liquid, found in the container/tank this was cast on. Containers like bottles and buckets are preserved.";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    private static Optional<FillingResult> getSpoutFillingRecipe(FluidStack fluidIngredient, ItemStack itemIngredient, Level world) {
        int requiredAmount;
        RecipeManager recipeManager = world.getRecipeManager();
        List allFillingRecipes = recipeManager.getAllRecipesFor(AllRecipeTypes.FILLING.getType());
        Optional<FillingRecipe> staticRecipe = allFillingRecipes.stream().map(RecipeHolder::value).filter(FillingRecipe.class::isInstance).map(FillingRecipe.class::cast).filter(recipe -> ((SizedFluidIngredient)recipe.getFluidIngredients().get(0)).ingredient().test(fluidIngredient)).filter(recipe -> ((Ingredient)recipe.getIngredients().get(0)).getItems()[0].getItem() == itemIngredient.getItem()).findFirst();
        if (staticRecipe.isPresent()) {
            FillingRecipe recipe2 = staticRecipe.get();
            FillingResult result = new FillingResult(recipe2.getResultItem((HolderLookup.Provider)world.registryAccess()).copy(), recipe2.getRequiredFluid().amount());
            return Optional.of(result);
        }
        if (GenericItemFilling.canItemBeFilled((Level)world, (ItemStack)itemIngredient) && (requiredAmount = GenericItemFilling.getRequiredAmountForItem((Level)world, (ItemStack)itemIngredient, (FluidStack)fluidIngredient)) != -1 && requiredAmount <= fluidIngredient.getAmount()) {
            ItemStack itemResult = GenericItemFilling.fillItem((Level)world, (int)requiredAmount, (ItemStack)itemIngredient, (FluidStack)fluidIngredient);
            fluidIngredient.setAmount(fluidIngredient.getAmount() + requiredAmount);
            FillingResult result = new FillingResult(itemResult, requiredAmount);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public record FillingResult(ItemStack output, int fluidAmount) {
    }
}

