/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.StorageHelpers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class EffectInsert
extends AbstractItemResolveEffect {
    public static EffectInsert INSTANCE = new EffectInsert(ArsTechnica.prefix("glyph_insert"), "Insert");

    private EffectInsert(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        boolean split;
        double expansion = 2.0 + spellStats.getAoeMultiplier();
        List<BlockEntity> containers = this.getContainersInArea(pos, world, (int)expansion);
        boolean bl = split = !spellStats.getAugments().stream().filter(x -> x == AugmentSplit.INSTANCE).findFirst().isEmpty();
        if (containers.size() > 0) {
            this.processItemEntities(world, entityList, containers, split);
        }
    }

    public void processItemEntities(Level world, List<ItemEntity> entityList, List<BlockEntity> containers, boolean split) {
        ArrayList<BlockPos> containerPosTargets = new ArrayList<BlockPos>();
        for (BlockEntity container : containers) {
            containerPosTargets.add(container.getBlockPos());
        }
        Iterator<ItemEntity> itemIterator = entityList.iterator();
        while (itemIterator.hasNext()) {
            ItemEntity itemEntity = itemIterator.next();
            ItemStack stack = itemEntity.getItem();
            if (stack.isEmpty()) {
                itemIterator.remove();
                continue;
            }
            if (split) {
                this.processItemsSplit(stack, itemEntity, itemIterator, world, containerPosTargets);
                continue;
            }
            this.processItemsNonSplit(stack, itemEntity, itemIterator, world, containerPosTargets);
        }
    }

    private void processItemsNonSplit(ItemStack stack, ItemEntity itemEntity, Iterator<ItemEntity> itemIterator, Level world, List<BlockPos> containerPosTargets) {
        IItemHandler itemHandler;
        BlockEntity bestContainer;
        BlockPos bestPos = StorageHelpers.getValidStorePos(world, containerPosTargets, stack);
        if (bestPos != null && (bestContainer = world.getBlockEntity(bestPos)) != null && (itemHandler = StorageHelpers.getItemCapFromTile(world, bestContainer)) != null) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (remaining.isEmpty()) {
                itemIterator.remove();
                itemEntity.discard();
            } else {
                itemEntity.setItem(remaining);
            }
        }
    }

    private void processItemsSplit(ItemStack stack, ItemEntity itemEntity, Iterator<ItemEntity> itemIterator, Level world, List<BlockPos> containerPosTargets) {
        List<BlockPos> validPositions = StorageHelpers.getValidStorePositions(world, containerPosTargets, stack);
        int totalItems = stack.getCount();
        int itemsPerContainer = totalItems / validPositions.size();
        int remainder = totalItems % validPositions.size();
        int itemsInserted = 0;
        for (BlockPos pos : validPositions) {
            IItemHandler itemHandler;
            BlockEntity container = world.getBlockEntity(pos);
            if (container == null || (itemHandler = StorageHelpers.getItemCapFromTile(world, container)) == null) continue;
            int itemsToInsert = itemsPerContainer + (remainder > 0 ? 1 : 0);
            ItemStack toInsert = new ItemStack((ItemLike)stack.getItem(), itemsToInsert);
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)toInsert, (boolean)false);
            int inserted = itemsToInsert - remaining.getCount();
            itemsInserted += inserted;
            remainder -= inserted > 0 ? 1 : 0;
        }
        if (itemsInserted >= totalItems) {
            itemIterator.remove();
            itemEntity.discard();
        } else {
            stack.setCount(totalItems - itemsInserted);
            itemEntity.setItem(stack);
        }
    }

    public List<BlockEntity> getContainersInArea(BlockPos pos, Level world, int expansion) {
        ArrayList<BlockEntity> containers = new ArrayList<BlockEntity>();
        BlockPos minPos = pos.offset(-expansion, -expansion, -expansion);
        BlockPos maxPos = pos.offset(expansion, expansion, expansion);
        for (BlockPos currentPos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockEntity tileEntity = world.getBlockEntity(currentPos);
            if (!(tileEntity instanceof Container)) continue;
            containers.add(tileEntity);
        }
        return containers;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Expands the range");
        map.put((AbstractAugment)AugmentSplit.INSTANCE, "Evenly distributes items across all valid containers for balanced deposit");
    }

    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentSplit.INSTANCE});
    }

    public String getBookDescription() {
        return "Inserts nearby items into nearby containers in a medium radius where this spell is activated.";
    }

    public int getDefaultManaCost() {
        return 15;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }
}

