/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.RecipeHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EffectApply
extends AbstractItemResolveEffect {
    public static EffectApply INSTANCE = new EffectApply(ArsTechnica.prefix("glyph_apply"), "Apply");

    private EffectApply(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockHitResult blockHit;
        BlockPos pos;
        if (rayTraceResult instanceof BlockHitResult && this.handleBlockApplication(pos = (blockHit = (BlockHitResult)rayTraceResult).getBlockPos(), blockHit, world, shooter, spellStats, spellContext, resolver)) {
            return;
        }
        super.onResolve(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    private boolean handleBlockApplication(BlockPos centerPos, BlockHitResult blockHitResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ApplyItemSource applySource = this.getApplyItemSource(spellContext.getCaster());
        if (applySource.isEmpty()) {
            return false;
        }
        double aoeBuff = spellStats.getAoeMultiplier();
        int pierceBuff = spellStats.getBuffCount((AbstractAugment)AugmentPierce.INSTANCE);
        List posList = SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)centerPos, (BlockHitResult)blockHitResult, (double)aoeBuff, (int)pierceBuff);
        int applicationsPerformed = 0;
        for (BlockPos pos : posList) {
            Block resultBlock;
            ItemApplicationRecipe iar;
            ItemStack result;
            ItemStack applyItem = applySource.getItem();
            if (applyItem.isEmpty()) break;
            BlockState targetBlock = world.getBlockState(pos);
            Optional<RecipeHolder<ItemApplicationRecipe>> recipe = this.getApplicationRecipe(applyItem, targetBlock, world);
            if (recipe.isEmpty() || (result = ((ItemApplicationRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)world.registryAccess())).isEmpty()) continue;
            Recipe recipe2 = recipe.get().value();
            if (recipe2 instanceof ItemApplicationRecipe && !(iar = (ItemApplicationRecipe)recipe2).shouldKeepHeldItem()) {
                applySource.consumeItem();
            }
            if ((resultBlock = Block.byItem((Item)result.getItem())) != null && !resultBlock.equals(Blocks.AIR)) {
                world.setBlock(pos, resultBlock.defaultBlockState(), 3);
            } else {
                ItemEntity resultEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, result.copy());
                world.addFreshEntity((Entity)resultEntity);
            }
            world.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.8f, 1.0f + (world.random.nextFloat() - 0.5f) * 0.4f);
            ++applicationsPerformed;
        }
        return applicationsPerformed > 0;
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ApplyItemSource applySource = this.getApplyItemSource(spellContext.getCaster());
        if (applySource.isEmpty()) {
            return;
        }
        int aoeBuff = (int)Math.round(spellStats.getAoeMultiplier());
        int maxAmountToApply = 4 * (1 + aoeBuff);
        int totalApplied = 0;
        for (ItemEntity itemEntity : entityList) {
            if (totalApplied >= maxAmountToApply) break;
            ItemStack itemStack = itemEntity.getItem();
            ItemStack applyItem = applySource.getItem();
            if (applyItem.isEmpty()) break;
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            boolean consumeItem = true;
            Optional<RecipeHolder<DeployerApplicationRecipe>> seqRecipe = RecipeHelpers.getSequencedAssemblyRecipe(AllRecipeTypes.DEPLOYING.getType(), DeployerApplicationRecipe.class, applyItem, itemStack, world);
            if (seqRecipe.isPresent()) {
                consumeItem = !((DeployerApplicationRecipe)seqRecipe.get().value()).shouldKeepHeldItem();
                results.addAll(((DeployerApplicationRecipe)seqRecipe.get().value()).rollResults(world.getRandom()));
            } else {
                Optional<RecipeHolder<ItemApplicationRecipe>> recipe = this.getApplicationRecipe(applyItem, itemStack, world);
                if (recipe.isPresent()) {
                    consumeItem = !((ItemApplicationRecipe)recipe.get().value()).shouldKeepHeldItem();
                    results.add(((ItemApplicationRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)world.registryAccess()));
                }
            }
            if (results.isEmpty()) continue;
            int remainingToApply = maxAmountToApply - totalApplied;
            int stackSize = itemStack.getCount();
            int applicationsToThisStack = Math.min(remainingToApply, stackSize);
            if ((applicationsToThisStack = Math.min(applicationsToThisStack, applySource.getAvailableCount())) <= 0) continue;
            if (consumeItem) {
                applySource.consumeItems(applicationsToThisStack);
            }
            itemStack.shrink(applicationsToThisStack);
            if (itemStack.getCount() <= 0) {
                itemEntity.discard();
            }
            for (int i = 0; i < applicationsToThisStack; ++i) {
                for (ItemStack result : results) {
                    ItemEntity resultEntity = new ItemEntity(world, itemEntity.getX() + (double)((world.random.nextFloat() - 0.5f) * 0.2f), itemEntity.getY(), itemEntity.getZ() + (double)((world.random.nextFloat() - 0.5f) * 0.2f), result.copy());
                    world.addFreshEntity((Entity)resultEntity);
                }
            }
            world.playSound(null, itemEntity.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.6f, 1.0f + (world.random.nextFloat() - 0.5f) * 0.4f);
            totalApplied += applicationsToThisStack;
            if (!applySource.isEmpty()) continue;
            break;
        }
    }

    private ApplyItemSource getApplyItemSource(IWrappedCaster caster) {
        if (caster instanceof PlayerCaster) {
            PlayerCaster playerCaster = (PlayerCaster)caster;
            return new PlayerApplyItemSource(playerCaster.player);
        }
        InventoryManager manager = caster.getInvManager();
        if (manager != null) {
            return new InventoryApplyItemSource(manager);
        }
        return new EmptyApplyItemSource();
    }

    private Optional<RecipeHolder<ItemApplicationRecipe>> getApplicationRecipe(ItemStack applyItem, ItemStack target, Level world) {
        Optional<RecipeHolder<ManualApplicationRecipe>> recipe = RecipeHelpers.getItemApplicationRecipe(applyItem, target, world);
        if (recipe.isPresent()) {
            return recipe.map(r -> new RecipeHolder(r.id(), (Recipe)((ItemApplicationRecipe)r.value())));
        }
        return RecipeHelpers.getDeployingRecipe(applyItem, target, world).map(r -> new RecipeHolder(r.id(), (Recipe)((ItemApplicationRecipe)r.value())));
    }

    private Optional<RecipeHolder<ItemApplicationRecipe>> getApplicationRecipe(ItemStack applyItem, BlockState target, Level world) {
        ItemStack targetItem = new ItemStack((ItemLike)target.getBlock().asItem());
        if (targetItem.isEmpty() || targetItem.getItem() == Items.AIR) {
            return Optional.empty();
        }
        return this.getApplicationRecipe(applyItem, targetItem, world);
    }

    public int getDefaultManaCost() {
        return 80;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        this.addBlockAoeAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the amount of items that can be applied to and the area of blocks affected");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Uses the item in your offhand to apply to blocks or items, such as applying andesite alloy to stripped logs to create casings. Also supports deploying items onto other items.";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }

    private static abstract class ApplyItemSource {
        private ApplyItemSource() {
        }

        @NotNull
        public abstract ItemStack getItem();

        public int getAvailableCount() {
            return this.getItem().getCount();
        }

        public abstract void consumeItems(int var1);

        public void consumeItem() {
            this.consumeItems(1);
        }

        public boolean isEmpty() {
            return this.getItem().isEmpty();
        }
    }

    private static class PlayerApplyItemSource
    extends ApplyItemSource {
        private final Player player;

        public PlayerApplyItemSource(Player player) {
            this.player = player;
        }

        @Override
        @NotNull
        public ItemStack getItem() {
            return this.player.getOffhandItem();
        }

        @Override
        public void consumeItems(int count) {
            this.getItem().shrink(count);
        }
    }

    private static class InventoryApplyItemSource
    extends ApplyItemSource {
        private InventoryManager manager;

        public InventoryApplyItemSource(InventoryManager manager) {
            this.manager = manager;
        }

        @Override
        @NotNull
        public ItemStack getItem() {
            SlotReference ref = this.manager.findItem(s -> true, InteractType.EXTRACT);
            if (ref.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return ref.getHandler().getStackInSlot(ref.getSlot());
        }

        @Override
        public void consumeItems(int count) {
            this.manager.extractItem(s -> true, 1);
        }
    }

    private static class EmptyApplyItemSource
    extends ApplyItemSource {
        private EmptyApplyItemSource() {
        }

        @Override
        @NotNull
        public ItemStack getItem() {
            return ItemStack.EMPTY;
        }

        @Override
        public int getAvailableCount() {
            return 0;
        }

        @Override
        public void consumeItem() {
        }

        @Override
        public void consumeItems(int count) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

