/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity;

import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.zeroregard.ars_technica.client.ClientHandler;
import com.zeroregard.ars_technica.helpers.SpellResolverHelpers;
import com.zeroregard.ars_technica.kinetics.WhirlCurrent;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcaneWhirlEntity
extends Entity
implements IAirCurrentSource,
GeoEntity {
    private float radius;
    private int duration;
    private final Level world;
    private float speed = 0.05f;
    private FanProcessingType processor;
    private WhirlCurrent current;
    private final SpellResolver spellResolver;
    private boolean soundPlaying;
    private boolean swirlPhysicsEnabled = true;
    private BlockPos boundDepotPos;
    private static final EntityDataAccessor<String> PROCESSOR_TYPE = SynchedEntityData.defineId(ArcaneWhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(ArcaneWhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.defineId(ArcaneWhirlEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public float getRadius() {
        return this.radius;
    }

    public Level getLevel() {
        return this.world;
    }

    public float getScaledSpeed() {
        return this.speed / 0.05f;
    }

    public FanProcessingType getProcessor() {
        return this.processor;
    }

    public boolean isSwirlPhysicsEnabled() {
        return this.swirlPhysicsEnabled;
    }

    public BlockPos getBoundDepotPos() {
        return this.boundDepotPos;
    }

    public ArcaneWhirlEntity(EntityType<? extends ArcaneWhirlEntity> entityType, Level world) {
        super(entityType, world);
        this.radius = 1.0f;
        this.duration = 100;
        this.world = world;
        this.spellResolver = null;
    }

    public ArcaneWhirlEntity(Level world, Vec3 position, float radius, int duration, FanProcessingType processor, SpellResolver spellResolver) {
        super((EntityType)EntityRegistry.ARCANE_WHIRL_ENTITY.get(), world);
        this.setPos(position.x, position.y, position.z);
        this.duration = duration;
        this.world = world;
        this.spellResolver = spellResolver;
        this.setRadius(radius);
        this.radius = radius;
        this.setSpeed(SpellResolverHelpers.hasTransmutationFocus(spellResolver) ? 0.1f : 0.05f);
        this.setProcessor(processor);
        this.current = new WhirlCurrent(this);
    }

    public void tick() {
        super.tick();
        this.handleWhirlwindEffect();
    }

    private void moveDown() {
        this.setPos(this.getX(), this.getY() - (double)0.03f, this.getZ());
    }

    private void setSpeed(float speed) {
        this.entityData.set(SPEED, (Object)Float.valueOf(speed));
    }

    private void setProcessor(FanProcessingType processor) {
        this.entityData.set(PROCESSOR_TYPE, (Object)this.getProcessorLegacyId(processor));
    }

    private void setRadius(float radius) {
        this.entityData.set(RADIUS, (Object)Float.valueOf(radius));
    }

    private String getProcessorLegacyId(FanProcessingType processor) {
        if (processor == AllFanProcessingTypes.BLASTING) {
            return "BLASTING";
        }
        if (processor == AllFanProcessingTypes.HAUNTING) {
            return "HAUNTING";
        }
        if (processor == AllFanProcessingTypes.SMOKING) {
            return "SMOKING";
        }
        if (processor == AllFanProcessingTypes.SPLASHING) {
            return "SPLASHING";
        }
        return "NONE";
    }

    public void bindDepot(BlockPos depotPos) {
        this.boundDepotPos = depotPos;
        this.swirlPhysicsEnabled = false;
    }

    private void handleWhirlwindEffect() {
        if (!this.world.isClientSide) {
            --this.duration;
            if (this.current != null) {
                this.current.tick(this.spellResolver);
            }
            if (this.duration <= 0) {
                if (this.current != null) {
                    this.current.stopAffectedItems();
                }
                this.discard();
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder dataBuilder) {
        dataBuilder.define(PROCESSOR_TYPE, (Object)"");
        dataBuilder.define(SPEED, (Object)Float.valueOf(0.05f));
        dataBuilder.define(RADIUS, (Object)Float.valueOf(1.5f));
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SPEED.equals(key)) {
            this.speed = ((Float)this.entityData.get(SPEED)).floatValue();
        }
        if (PROCESSOR_TYPE.equals(key)) {
            String val = (String)this.entityData.get(PROCESSOR_TYPE);
            this.processor = val.isEmpty() ? null : AllFanProcessingTypes.parseLegacy((String)((String)this.entityData.get(PROCESSOR_TYPE)));
            this.initSound();
        }
        if (RADIUS.equals(key)) {
            this.radius = ((Float)this.entityData.get(RADIUS)).floatValue();
        }
    }

    private void initSound() {
        if (this.world.isClientSide && !this.soundPlaying) {
            ClientHandler.handleWhirlSound(this, this.processor, this.speed);
            this.soundPlaying = true;
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.duration = compound.getInt("Duration");
        this.setRadius(compound.getFloat("Radius"));
        this.setSpeed(compound.getFloat("Speed"));
        if (compound.contains("ProcessorType")) {
            String processorType = compound.getString("ProcessorType");
            this.setProcessor(AllFanProcessingTypes.parseLegacy((String)processorType));
        }
        if (compound.contains("SwirlPhysics")) {
            this.swirlPhysicsEnabled = compound.getBoolean("SwirlPhysics");
        }
        if (compound.contains("DepotX")) {
            int x = compound.getInt("DepotX");
            int y = compound.getInt("DepotY");
            int z = compound.getInt("DepotZ");
            this.boundDepotPos = new BlockPos(x, y, z);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Duration", this.duration);
        compound.putFloat("Radius", this.radius);
        compound.putFloat("Speed", this.speed);
        if (this.processor != null) {
            compound.putString("ProcessorType", this.getProcessorLegacyId(this.processor));
        }
        compound.putBoolean("SwirlPhysics", this.swirlPhysicsEnabled);
        if (this.boundDepotPos != null) {
            compound.putInt("DepotX", this.boundDepotPos.getX());
            compound.putInt("DepotY", this.boundDepotPos.getY());
            compound.putInt("DepotZ", this.boundDepotPos.getZ());
        }
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return null;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return null;
    }

    public BlockPos getAirCurrentPos() {
        return null;
    }

    public float getSpeed() {
        return this.speed;
    }

    public Direction getAirflowOriginSide() {
        return null;
    }

    @Nullable
    public Direction getAirFlowDirection() {
        return null;
    }

    public boolean isSourceRemoved() {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "rotateController", 0, this::rotateAnimationPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState rotateAnimationPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        event.getController().setAnimationSpeed((double)(0.75f * (this.speed / 0.05f)));
        return PlayState.CONTINUE;
    }
}

