/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.particles;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SpiralDustParticle
extends TextureSheetParticle {
    private final float radius;
    private final float speed;
    private float angle = (float)(Math.random() * 2.0 * Math.PI);
    public float initScale;
    private final float initialQuadSize;

    protected SpiralDustParticle(ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, float r, float g, float b, float scale, int lifetime, SpriteSet sprite) {
        super(worldIn, x, y, z, 0.0, 0.0, 0.0);
        this.radius = 0.1f;
        this.speed = 0.1f;
        this.initialQuadSize = this.quadSize = scale * 0.08f + (float)(Math.random() * 0.04);
        this.hasPhysics = false;
        this.initScale = scale * 0.01f;
        this.xd = ParticleUtil.inRange((double)-0.01, (double)0.01);
        this.yd = -0.02;
        this.zd = ParticleUtil.inRange((double)-0.01, (double)0.01);
        this.friction = 0.96f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.setColor(r, g, b);
        this.lifetime = lifetime + (int)Math.floor(Math.random() * 50.0);
        this.pickSprite(sprite);
    }

    public void tick() {
        super.tick();
        this.angle += this.speed;
        if ((double)this.angle > Math.PI * 2) {
            this.angle = (float)((double)this.angle - Math.PI * 2);
        }
        double x = this.x + (double)this.radius * 0.5 * Math.sin(this.angle);
        double y = this.y + 0.025;
        double z = this.z + (double)this.radius * 0.5 * Math.cos(this.angle);
        float progress = Math.min((float)this.age / (float)this.lifetime, 1.0f);
        float easedProgress = this.applyEasingFunction(progress);
        this.quadSize = this.initialQuadSize - easedProgress * this.initialQuadSize;
        this.setPos(x, y, z);
    }

    private float applyEasingFunction(float progress) {
        if (progress <= 0.0f) {
            return 0.0f;
        }
        if (progress >= 1.0f) {
            return 1.0f;
        }
        return (float)Math.pow(2.0, 10.0f * (progress - 1.0f));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }
}

