/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.gui;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.CreateLang;
import com.zeroregard.ars_technica.client.gui.AllGuiTextures;
import com.zeroregard.ars_technica.client.gui.RenderableScrollInput;
import com.zeroregard.ars_technica.helpers.CooldownHelper;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public abstract class CooldownScreen<T>
extends AbstractSimiScreen {
    private ScrollInput slider;
    protected T blockEntity;
    protected int min;
    protected int max;
    private final AllGuiTextures background = AllGuiTextures.SOURCE_MOTOR_SCREEN;

    public CooldownScreen(String titleKey, T blockEntity, int min, int max) {
        super((Component)CreateLang.translateDirect((String)titleKey, (Object[])new Object[0]));
        this.blockEntity = blockEntity;
        this.min = min;
        this.max = max;
    }

    protected void init() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(15, 0);
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.slider = new RenderableScrollInput(x + 8, y + 39, 213, 9).withRange(this.min, this.max + 1).titled(CreateLang.translateDirect((String)"gui.ars_technica.cooldown", (Object[])new Object[0])).calling(state -> {
            this.updateEntity((Integer)state);
            this.slider.titled(CreateLang.translateDirect((String)"gui.ars_technica.cooldown", (Object[])new Object[]{state}));
        }).setState(this.getInitialEntityStateValue());
        this.addRenderableWidget((GuiEventListener)this.slider);
        IconButton confirmButton = new IconButton(x + 202, y + 75, (ScreenElement)AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> this.onClose());
        this.addRenderableWidget((GuiEventListener)confirmButton);
    }

    protected abstract void updateEntity(Integer var1);

    protected abstract int getInitialEntityStateValue();

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.title, x + (this.background.width - 8) / 2 - this.font.width((FormattedText)this.title) / 2, y + 4, 5841956, false);
        int stateValue = this.slider.getState();
        ((RenderableScrollInput)this.slider).renderSlider(CooldownHelper.getCooldownText(stateValue), graphics, this.font, "");
    }

    public void removed() {
        this.send(this.slider.getState());
    }

    protected abstract void send(int var1);
}

