/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.block;

import com.hollingsworth.arsnouveau.api.source.AbstractSourceMachine;
import com.hollingsworth.arsnouveau.api.source.ISourceTile;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.zeroregard.ars_technica.api.IModifiableCooldown;
import com.zeroregard.ars_technica.helpers.CooldownHelper;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class PreciseRelayTile
extends RelayTile
implements IModifiableCooldown {
    private int customCooldownTicks = -1;
    private AnimationController rotateController;

    public PreciseRelayTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityRegistry.PRECISE_RELAY_TILE.get(), pos, state);
    }

    public void getTooltip(List<Component> tooltip) {
        super.getTooltip(tooltip);
        int cooldownTicks = this.getCooldownTicks();
        if (cooldownTicks == -1) {
            cooldownTicks = 20;
        }
        int transferRate = this.getTransferRate();
        String coolDownText = CooldownHelper.getCooldownText(cooldownTicks);
        tooltip.add((Component)Component.empty());
        MutableComponent transferRateComponent = Component.translatable((String)"ars_nouveau.relay.transfer_rate", (Object[])new Object[]{transferRate, coolDownText}).setStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)transferRateComponent);
    }

    public void tick() {
        if (this.level.isClientSide && this.rotateController != null) {
            int divider = this.customCooldownTicks == 0 ? 1 : this.customCooldownTicks;
            this.rotateController.setAnimationSpeed(20.0 / (double)divider);
        }
        if (this.level.isClientSide || this.disabled) {
            return;
        }
        if (this.shouldStall()) {
            return;
        }
        BlockPos fromPos = this.getFromPos();
        BlockPos toPos = this.getToPos();
        if (fromPos != null && this.level.isLoaded(fromPos)) {
            AbstractSourceMachine fromTile;
            if (!(this.level.getBlockEntity(fromPos) instanceof AbstractSourceMachine)) {
                this.setFromPos(null);
                this.updateBlock();
                return;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(fromPos);
            if (blockEntity instanceof AbstractSourceMachine && this.transferSource((ISourceTile)(fromTile = (AbstractSourceMachine)blockEntity), (ISourceTile)this) > 0) {
                this.updateBlock();
                ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)fromPos, (BlockPos)this.worldPosition, (ParticleColor)this.getColor());
            }
        }
        if (toPos != null && this.level.isLoaded(toPos)) {
            if (!(this.level.getBlockEntity(toPos) instanceof AbstractSourceMachine)) {
                this.setToPos(null);
                this.updateBlock();
                return;
            }
            AbstractSourceMachine toTile = (AbstractSourceMachine)this.level.getBlockEntity(toPos);
            if (this.transferSource((ISourceTile)this, (ISourceTile)toTile) > 0) {
                ParticleUtil.spawnFollowProjectile((Level)this.level, (BlockPos)this.worldPosition, (BlockPos)toPos, (ParticleColor)this.getColor());
            }
        }
    }

    private boolean shouldStall() {
        if (this.customCooldownTicks == 0) {
            return false;
        }
        if (this.customCooldownTicks == -1) {
            return this.level.getGameTime() % 20L != 0L;
        }
        return this.level.getGameTime() % (long)this.customCooldownTicks != 0L;
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.customCooldownTicks != -1) {
            tag.putInt("CustomCooldown", this.customCooldownTicks);
        }
    }

    public void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        int coolDown = tag.getInt("CustomCooldown");
        if (coolDown != -1) {
            this.customCooldownTicks = coolDown;
        }
    }

    @Override
    public void setCooldownTicks(int ticks) {
        this.customCooldownTicks = ticks;
    }

    @Override
    public int getCooldownTicks() {
        return this.customCooldownTicks;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        this.rotateController = new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate);
        data.add(this.rotateController);
        data.add(new AnimationController((GeoAnimatable)this, "float_controller", 0, this::floatPredicate));
    }

    private <P extends GeoAnimatable> PlayState idlePredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("floating"));
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState floatPredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotation"));
        return PlayState.CONTINUE;
    }
}

