/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.armor;

import com.alexthw.sauce.event.AttributeEventHandler;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.mana.IManaDiscountEquipment;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.armor.AnimatedMagicArmor;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.Config;
import com.zeroregard.ars_technica.armor.ATMaterials;
import com.zeroregard.ars_technica.armor.TechnomancerArmorModel;
import com.zeroregard.ars_technica.client.armor.LightTechnomancerArmorRenderer;
import com.zeroregard.ars_technica.client.utils.TooltipUtils;
import com.zeroregard.ars_technica.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class LightTechnomancerArmor
extends AnimatedMagicArmor
implements ISpellModifierItem,
IManaDiscountEquipment {
    private final String specialInformation;
    private static final EnumMap<ArmorItem.Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), p_266744_ -> {
        p_266744_.put(ArmorItem.Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        p_266744_.put(ArmorItem.Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        p_266744_.put(ArmorItem.Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        p_266744_.put(ArmorItem.Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
    });
    EquipmentSlot[] OrderedSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Supplier<Item[]> orderedItemsSupplier = () -> new Item[]{(Item)ItemRegistry.ARTIFICER_CAP.get(), (Item)ItemRegistry.ARTIFICER_TUNIC.get(), (Item)ItemRegistry.ARTIFICER_PANTS.get(), (Item)ItemRegistry.ARTIFICER_SHOES.get()};

    public LightTechnomancerArmor(ArmorItem.Type slot, @Nullable String tooltipSpecialInformation, Item.Properties builder) {
        super(ATMaterials.techno_light, slot, builder, new TechnomancerArmorModel("artificer_armor").withEmptyAnim());
        this.specialInformation = tooltipSpecialInformation;
    }

    public int getMinTier() {
        return 2;
    }

    @Nullable
    public ResourceLocation getArmorTexture(@NotNull ItemStack stack, @NotNull Entity entity, @NotNull EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return null;
    }

    public int getManaDiscount(ItemStack i, Spell spell) {
        return Mth.ceil((double)this.getDiscount(spell.unsafeList()));
    }

    double getDiscount(List<AbstractSpellPart> recipe) {
        double sum = 0.0;
        for (AbstractSpellPart part : recipe) {
            if (!SpellSchools.MANIPULATION.isPartOfSchool(part)) continue;
            sum += 0.2 * (double)part.getCastingCost();
        }
        return Mth.ceil((double)sum);
    }

    public String getColor(ItemStack object) {
        return ((DyeColor)object.getOrDefault(DataComponents.BASE_COLOR, (Object)DyeColor.PURPLE)).getName();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        ArmorPerkHolder perkProvider = PerkUtil.getPerkHolder((ItemStack)stack);
        if (perkProvider != null) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.tier", (Object[])new Object[]{4}).withStyle(ChatFormatting.GOLD));
            perkProvider.appendPerkTooltip(tooltip, stack);
        }
        TooltipUtils.addOnShift(tooltip, () -> this.addInformationAfterShift(stack, context, tooltip, flags), "armor_set");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addInformationAfterShift(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        Player player = ArsNouveau.proxy.getPlayer();
        if (player != null) {
            ArrayList<MutableComponent> equippedList = new ArrayList<MutableComponent>();
            Item[] orderedItems = this.orderedItemsSupplier.get();
            int equippedCounter = 0;
            for (int i = 0; i < this.OrderedSlots.length; ++i) {
                EquipmentSlot slot = this.OrderedSlots[i];
                Item armor = orderedItems[i];
                MutableComponent cmp = Component.literal((String)" - ").append(armor.getDefaultInstance().getHoverName());
                if (player.getItemBySlot(slot).getItem() == armor) {
                    cmp.withStyle(ChatFormatting.GREEN);
                    ++equippedCounter;
                } else {
                    cmp.withStyle(ChatFormatting.GRAY);
                }
                equippedList.add(cmp);
            }
            list.add(this.getArmorSetTitle(equippedCounter));
            list.addAll(equippedList);
            Component specialInfo = this.getArmorPieceSpecialInformation();
            if (specialInfo != null) {
                list.add(specialInfo);
            }
            list.add((Component)Component.translatable((String)"ars_technica.armor_set.artificer.desc").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers().withModifierAdded((Holder)PerkAttributes.MAX_MANA, new AttributeModifier(ArsNouveau.prefix((String)("max_mana_armor_" + this.type.getName())), (double)((Integer)Config.Common.ARMOR_MAX_MANA.get()).intValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot())).withModifierAdded((Holder)PerkAttributes.MANA_REGEN_BONUS, new AttributeModifier(ArsNouveau.prefix((String)("mana_regen_armor_" + this.type.getName())), (double)((Integer)Config.Common.ARMOR_MANA_REGEN.get()).intValue(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
        if (AttributeEventHandler.schoolToPowerAttribute.get(SpellSchools.MANIPULATION) != null) {
            modifiers = modifiers.withModifierAdded((Holder)AttributeEventHandler.schoolToPowerAttribute.get(SpellSchools.MANIPULATION), new AttributeModifier(ArsTechnica.prefix("manipulation_power_armor_" + this.type.getName()), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
        }
        for (PerkInstance perkInstance : PerkUtil.getPerksFromItem((ItemStack)stack)) {
            IPerk perk = perkInstance.getPerk();
            modifiers = perk.applyAttributeModifiers(modifiers, stack, perkInstance.getSlot().value(), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot()));
        }
        return modifiers;
    }

    private Component getArmorSetTitle(int equipped) {
        return Component.translatable((String)"ars_technica.armor_set.artificer").append(" (" + equipped + " / 4)").withStyle(ChatFormatting.DARK_AQUA);
    }

    @Nullable
    private Component getArmorPieceSpecialInformation() {
        if (this.specialInformation == null) {
            return null;
        }
        return Component.translatable((String)("ars_technica" + this.specialInformation)).withStyle(ChatFormatting.GOLD);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new LightTechnomancerArmorRenderer((GeoModel<AnimatedMagicArmor>)LightTechnomancerArmor.this.getArmorModel());
                }
                return this.renderer;
            }
        });
    }

    public static boolean isWearingFullSet(LivingEntity entity) {
        ItemStack head = entity.getItemBySlot(EquipmentSlot.HEAD);
        ItemStack chest = entity.getItemBySlot(EquipmentSlot.CHEST);
        ItemStack legs = entity.getItemBySlot(EquipmentSlot.LEGS);
        ItemStack boots = entity.getItemBySlot(EquipmentSlot.FEET);
        return head.getItem() instanceof LightTechnomancerArmor && chest.getItem() instanceof LightTechnomancerArmor && legs.getItem() instanceof LightTechnomancerArmor && boots.getItem() instanceof LightTechnomancerArmor;
    }
}

