/*
 * Decompiled with CFR 0.152.
 */
package com.traverse.bhc.common.util;

import com.traverse.bhc.common.BaubleyHeartCanisters;
import com.traverse.bhc.common.items.ItemHeartPulseBelt;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="bhc")
public class HeartPulseHandler {
    public static final ResourceLocation MOVEMENT_SPEED_MODIFIER_ID = BaubleyHeartCanisters.id("heartpulse_movement_speed");
    public static final ResourceLocation STEP_HEIGHT_MODIFIER_ID = BaubleyHeartCanisters.id("heartpulse_step_height");
    public static final ResourceLocation JUMP_STRENGTH_MODIFIER_ID = BaubleyHeartCanisters.id("heartpulse_jump_strength");
    private static final double BASE_MOVEMENT_SPEED_BONUS = 0.12;
    private static final double STEP_HEIGHT_ADDITION = 0.4;
    private static final double JUMP_STRENGTH_ADDITION = 0.08;

    public static void applyPulseEffects(Player player, boolean apply, int multiplier) {
        if (apply) {
            HeartPulseHandler.applyMovementSpeed(player, multiplier);
            HeartPulseHandler.applyStepHeight(player);
            HeartPulseHandler.applyJumpStrength(player, multiplier);
        } else {
            HeartPulseHandler.removeMovementSpeed(player);
            HeartPulseHandler.removeStepHeight(player);
            HeartPulseHandler.removeJumpStrength(player);
        }
    }

    private static void applyStepHeight(Player player) {
        Holder holder = Attributes.STEP_HEIGHT;
        AttributeInstance inst = player.getAttribute(holder);
        if (inst == null) {
            return;
        }
        if (inst.getModifier(STEP_HEIGHT_MODIFIER_ID) != null) {
            inst.removeModifier(STEP_HEIGHT_MODIFIER_ID);
        }
        inst.addPermanentModifier(new AttributeModifier(STEP_HEIGHT_MODIFIER_ID, 0.4, AttributeModifier.Operation.ADD_VALUE));
    }

    private static void removeStepHeight(Player player) {
        Holder holder = Attributes.STEP_HEIGHT;
        AttributeInstance inst = player.getAttribute(holder);
        if (inst != null) {
            inst.removeModifier(STEP_HEIGHT_MODIFIER_ID);
        }
    }

    private static void applyMovementSpeed(Player player, int multiplier) {
        AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (movementSpeed != null) {
            AttributeModifier existingModifier = movementSpeed.getModifier(MOVEMENT_SPEED_MODIFIER_ID);
            if (existingModifier != null) {
                movementSpeed.removeModifier(MOVEMENT_SPEED_MODIFIER_ID);
            }
            double speedBonus = 0.12 * (double)multiplier;
            movementSpeed.addPermanentModifier(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_ID, speedBonus, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
    }

    private static void removeMovementSpeed(Player player) {
        AttributeInstance movementSpeed = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (movementSpeed != null) {
            movementSpeed.removeModifier(MOVEMENT_SPEED_MODIFIER_ID);
        }
    }

    private static void applyJumpStrength(Player player, int multiplier) {
        Holder holder = Attributes.JUMP_STRENGTH;
        AttributeInstance inst = player.getAttribute(holder);
        if (inst == null) {
            return;
        }
        if (inst.getModifier(JUMP_STRENGTH_MODIFIER_ID) != null) {
            inst.removeModifier(JUMP_STRENGTH_MODIFIER_ID);
        }
        double jump_height = 0.08 * (double)multiplier;
        inst.addPermanentModifier(new AttributeModifier(JUMP_STRENGTH_MODIFIER_ID, jump_height, AttributeModifier.Operation.ADD_VALUE));
    }

    private static void removeJumpStrength(Player player) {
        AttributeInstance movementSpeed = player.getAttribute(Attributes.JUMP_STRENGTH);
        if (movementSpeed != null) {
            movementSpeed.removeModifier(JUMP_STRENGTH_MODIFIER_ID);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        if (HeartPulseHandler.isCuriosEqupped(event.getEntity()) != null && event.getDistance() <= 6.0f) {
            event.setCanceled(true);
        }
    }

    public static SlotResult isCuriosEqupped(LivingEntity entity) {
        Optional curiosHandler;
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide() && (curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)entity)).isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)curiosHandler.get();
            return handler.findFirstCurio(itemStack -> itemStack.getItem() instanceof ItemHeartPulseBelt).orElse(null);
        }
        return null;
    }
}

