/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import com.direwolf20.justdirethings.setup.Config;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ConfigValueComponentProcessor
implements IComponentProcessor {
    private String rawText;
    private List<String> options;

    public void setup(Level level, IVariableProvider iVariableProvider) {
        this.rawText = iVariableProvider.get("text", (HolderLookup.Provider)level.registryAccess()).asString();
        this.options = iVariableProvider.get("config_options", (HolderLookup.Provider)level.registryAccess()).asList((HolderLookup.Provider)level.registryAccess()).stream().map(IVariable::asString).toList();
    }

    public IVariable process(Level level, String key) {
        if (!key.equals("text")) {
            return null;
        }
        String result = this.rawText;
        for (String option : this.options) {
            Object value = ((ModConfigSpec.ConfigValue)Config.SERVER_CONFIG.getValues().get(option)).get();
            result = result.replace("#" + option + "#", String.valueOf(value));
        }
        return IVariable.wrap((String)result, (HolderLookup.Provider)level.registryAccess());
    }
}

