/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.datagen.recipes;

import com.direwolf20.justdirethings.common.items.abilityupgrades.Upgrade;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AbilityRecipe
implements SmithingRecipe {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;

    public AbilityRecipe(Ingredient template, Ingredient base, Ingredient addition) {
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    public boolean matches(SmithingRecipeInput p_346082_, Level p_345460_) {
        return this.template.test(p_346082_.template()) && this.base.test(p_346082_.base()) && this.addition.test(p_346082_.addition());
    }

    public ItemStack assemble(SmithingRecipeInput smithingRecipeInput, HolderLookup.Provider provider) {
        Item item;
        ItemStack base = smithingRecipeInput.base();
        ItemStack upgrade = smithingRecipeInput.addition();
        if (this.isBaseIngredient(base) && (item = base.getItem()) instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            Ability ability = Ability.getAbilityFromUpgradeItem(upgrade.getItem());
            if (ability != null && toggleableTool.hasAbility(ability) && !ToggleableTool.hasUpgrade(base, ability) && ((Boolean)Config.AVAILABLE_ABILITY_MAP.get((Object)ability).get()).booleanValue()) {
                ItemStack itemstack1 = base.copyWithCount(1);
                itemstack1.set((Supplier)JustDireDataComponents.ABILITY_UPGRADE_INSTALLS.get((Object)ability), (Object)true);
                return itemstack1;
            }
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        ItemStack itemstack = new ItemStack((ItemLike)this.getBase().getItems()[0].getItem());
        Ability ability = Ability.getAbilityFromUpgradeItem(this.getAddition().getItems()[0].getItem());
        if (Config.SERVER_CONFIG.isLoaded() && !((Boolean)Config.AVAILABLE_ABILITY_MAP.get((Object)ability).get()).booleanValue()) {
            return new ItemStack((ItemLike)Items.AIR);
        }
        itemstack.set((Supplier)JustDireDataComponents.ABILITY_UPGRADE_INSTALLS.get((Object)ability), (Object)true);
        return itemstack;
    }

    public boolean isTemplateIngredient(ItemStack stack) {
        return stack.isEmpty();
    }

    public boolean isBaseIngredient(ItemStack stack) {
        return stack.getItem() instanceof ToggleableTool;
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return stack.getItem() instanceof Upgrade;
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(Ingredient::hasNoItems);
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.ABILITY_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<AbilityRecipe> {
        private static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"ability");
        private static final MapCodec<AbilityRecipe> CODEC = RecordCodecBuilder.mapCodec(p_311734_ -> p_311734_.group((App)Ingredient.CODEC.fieldOf("template").forGetter(p_301070_ -> p_301070_.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(p_300969_ -> p_300969_.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(p_300977_ -> p_300977_.addition)).apply((Applicative)p_311734_, AbilityRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AbilityRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AbilityRecipe::getTemplate, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AbilityRecipe::getBase, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AbilityRecipe::getAddition, AbilityRecipe::new);

        public MapCodec<AbilityRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AbilityRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

