/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items;

import com.direwolf20.justdirethings.common.blocks.resources.CoalBlock_T1;
import com.direwolf20.justdirethings.common.capabilities.EnergyStorageItemStackNoReceive;
import com.direwolf20.justdirethings.common.containers.PocketGeneratorContainer;
import com.direwolf20.justdirethings.common.items.FuelCanister;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.common.items.resources.Coal_T1;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.TooltipHelpers;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ComponentItemHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class PocketGenerator
extends Item
implements PoweredItem,
ToggleableItem {
    public static final EntityCapability<IItemHandler, Void> CURIOS_INVENTORY = EntityCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"item_handler"), IItemHandler.class);

    public PocketGenerator() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        if (!player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new PocketGeneratorContainer(windowId, playerInventory, player, itemstack), (Component)Component.translatable((String)"")), buf -> ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)itemstack));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level world, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (world.isClientSide) {
            return;
        }
        if (entity instanceof Player) {
            ToggleableItem toggleableItem;
            Player player = (Player)entity;
            Item item = itemStack.getItem();
            if (item instanceof ToggleableItem && (toggleableItem = (ToggleableItem)item).getEnabled(itemStack)) {
                IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage == null) {
                    return;
                }
                if (energyStorage instanceof EnergyStorageItemStackNoReceive) {
                    EnergyStorageItemStackNoReceive EnergyStorageItemStackNoReceive2 = (EnergyStorageItemStackNoReceive)energyStorage;
                    this.tryBurn(EnergyStorageItemStackNoReceive2, itemStack);
                    if (energyStorage.getEnergyStored() >= this.getFEPerTick() / 10) {
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack slotStack = player.getInventory().getItem(i);
                            this.transferEnergy(slotStack, energyStorage);
                        }
                        IItemHandler curios = (IItemHandler)player.getCapability(CURIOS_INVENTORY);
                        if (curios != null) {
                            for (int i = 0; i < curios.getSlots(); ++i) {
                                ItemStack slotStack = curios.getStackInSlot(i);
                                this.transferEnergy(slotStack, energyStorage);
                            }
                        }
                    }
                }
            }
        }
    }

    private void transferEnergy(ItemStack slotStack, IEnergyStorage energyStorage) {
        int acceptedEnergy;
        IEnergyStorage slotEnergy = (IEnergyStorage)slotStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (slotEnergy != null && (acceptedEnergy = slotEnergy.receiveEnergy(this.getFEPerTick(), true)) > 0) {
            int extractedEnergy = energyStorage.extractEnergy(acceptedEnergy, false);
            slotEnergy.receiveEnergy(extractedEnergy, false);
        }
    }

    private int fePerTick(ItemStack itemStack) {
        return this.getFePerFuelTick() * this.getBurnSpeedMultiplier(itemStack);
    }

    public void tryBurn(EnergyStorageItemStackNoReceive energyStorage, ItemStack itemStack) {
        boolean canInsertEnergy;
        boolean bl = canInsertEnergy = energyStorage.forceReceiveEnergy(this.fePerTick(itemStack), true) > 0;
        if ((Integer)itemStack.getOrDefault(JustDireDataComponents.POCKETGEN_COUNTER, (Object)0) > 0 && canInsertEnergy) {
            this.burn(energyStorage, itemStack);
        } else if (canInsertEnergy && this.initBurn(itemStack)) {
            this.burn(energyStorage, itemStack);
        }
    }

    private void burn(EnergyStorageItemStackNoReceive energyStorage, ItemStack itemStack) {
        energyStorage.forceReceiveEnergy(this.fePerTick(itemStack), false);
        int counter = (Integer)itemStack.getOrDefault(JustDireDataComponents.POCKETGEN_COUNTER, (Object)0);
        itemStack.set(JustDireDataComponents.POCKETGEN_COUNTER, (Object)(--counter));
        if (counter == 0) {
            itemStack.set(JustDireDataComponents.POCKETGEN_MAXBURN, (Object)0);
            this.initBurn(itemStack);
        }
    }

    private boolean initBurn(ItemStack itemStack) {
        ComponentItemHandler handler = new ComponentItemHandler((MutableDataComponentHolder)itemStack, (DataComponentType)JustDireDataComponents.ITEMSTACK_HANDLER.get(), 1);
        ItemStack fuelStack = handler.getStackInSlot(0);
        int burnTime = fuelStack.getBurnTime(RecipeType.SMELTING);
        if (burnTime > 0) {
            int counter;
            Item item = fuelStack.getItem();
            if (item instanceof Coal_T1) {
                Coal_T1 direCoal = (Coal_T1)item;
                this.setFuelMultiplier(itemStack, direCoal.getBurnSpeedMultiplier());
            } else {
                BlockItem blockItem;
                item = fuelStack.getItem();
                if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof CoalBlock_T1) {
                    CoalBlock_T1 coalBlock = (CoalBlock_T1)item;
                    this.setFuelMultiplier(itemStack, coalBlock.getBurnSpeedMultiplier());
                } else if (fuelStack.getItem() instanceof FuelCanister) {
                    this.setFuelMultiplier(itemStack, FuelCanister.getBurnSpeedMultiplier(fuelStack));
                } else {
                    this.setFuelMultiplier(itemStack, 1);
                }
            }
            if (fuelStack.hasCraftingRemainingItem()) {
                handler.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
            } else {
                fuelStack.shrink(1);
                handler.setStackInSlot(0, fuelStack);
            }
            int maxBurn = counter = (int)(Math.floor(burnTime) / (double)this.getBurnSpeedMultiplier(itemStack));
            itemStack.set(JustDireDataComponents.POCKETGEN_COUNTER, (Object)counter);
            itemStack.set(JustDireDataComponents.POCKETGEN_MAXBURN, (Object)maxBurn);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Level level = context.level();
        if (level == null) {
            return;
        }
        TooltipHelpers.appendFEText(stack, tooltip);
        TooltipHelpers.appendToolEnabled(stack, tooltip);
        TooltipHelpers.appendGeneratorDetails(stack, tooltip);
        TooltipHelpers.appendShiftForInfo(stack, tooltip);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isPowerBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.getPowerBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        int color = this.getPowerBarColor(stack);
        if (color == -1) {
            return super.getBarColor(stack);
        }
        return color;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void setFuelMultiplier(ItemStack itemStack, int amount) {
        itemStack.set(JustDireDataComponents.POCKETGEN_FUELMULT, (Object)amount);
    }

    public int getFuelMultiplier(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(JustDireDataComponents.POCKETGEN_FUELMULT, (Object)1);
    }

    @Override
    public int getMaxEnergy() {
        return (Integer)Config.POCKET_GENERATOR_MAX_FE.get();
    }

    public int getFEPerTick() {
        return (Integer)Config.POCKET_GENERATOR_FE_PER_TICK.get();
    }

    public int getFePerFuelTick() {
        return (Integer)Config.POCKET_GENERATOR_FE_PER_FUEL_TICK.get();
    }

    public int getBurnSpeedMultiplier(ItemStack itemStack) {
        return (Integer)Config.POCKET_GENERATOR_BURN_SPEED_MULTIPLIER.get() * this.getFuelMultiplier(itemStack);
    }
}

