/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.inventory.server.ContainerAbsorptionHopper;
import mob_grinding_utils.inventory.server.InventoryWrapperAH;
import mob_grinding_utils.tile.BEGuiClickable;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class TileEntityAbsorptionHopper
extends TileEntityInventoryHelper
implements MenuProvider,
BEGuiClickable {
    public FluidTank tank = new FluidTank(16000);
    private final IItemHandler itemHandler;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public int prevTankAmount;
    public EnumStatus[] status = new EnumStatus[]{EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE};
    public boolean showRenderBox;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public TileEntityAbsorptionHopper(BlockPos pos, BlockState state) {
        super(ModBlocks.ABSORPTION_HOPPER.getTileEntityType(), 17, pos, state);
        this.itemHandler = this.createUnSidedHandler();
    }

    @Override
    public void buttonClicked(int buttonID) {
        switch (buttonID) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.toggleMode(Direction.values()[buttonID]);
                break;
            }
            case 6: {
                this.toggleRenderBox();
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.toggleOffset(buttonID);
            }
        }
        this.updateBlock();
    }

    public IItemHandler getItemHandler(@Nullable Direction side) {
        return this.itemHandler;
    }

    public FluidTank getTank(Direction side) {
        return this.tank;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider lookupProvider) {
        EnumStatus[] old = new EnumStatus[]{this.status[0], this.status[1], this.status[2], this.status[3], this.status[4], this.status[5]};
        super.onDataPacket(net, packet, lookupProvider);
        this.loadAdditional(packet.getTag(), lookupProvider);
        for (Direction facing : Direction.values()) {
            if (old[facing.ordinal()] == this.status[facing.ordinal()]) continue;
            this.getLevel().setBlocksDirty(this.getBlockPos(), this.getLevel().getBlockState(this.getBlockPos()), this.getLevel().getBlockState(this.getBlockPos()));
            return;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag getUpdateTag(@Nonnull HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt, registries);
        return nbt;
    }

    @Override
    public void loadAdditional(CompoundTag tagCompound, HolderLookup.Provider registries) {
        super.loadAdditional(tagCompound, registries);
        this.status[0] = EnumStatus.values()[tagCompound.getByte("down")];
        this.status[1] = EnumStatus.values()[tagCompound.getByte("up")];
        this.status[2] = EnumStatus.values()[tagCompound.getByte("north")];
        this.status[3] = EnumStatus.values()[tagCompound.getByte("south")];
        this.status[4] = EnumStatus.values()[tagCompound.getByte("west")];
        this.status[5] = EnumStatus.values()[tagCompound.getByte("east")];
        this.showRenderBox = tagCompound.getBoolean("showRenderBox");
        this.offsetX = tagCompound.getInt("offsetX");
        this.offsetY = tagCompound.getInt("offsetY");
        this.offsetZ = tagCompound.getInt("offsetZ");
        this.tank.readFromNBT(registries, tagCompound);
    }

    @Override
    public void saveAdditional(CompoundTag tagCompound, HolderLookup.Provider registries) {
        super.saveAdditional(tagCompound, registries);
        tagCompound.putByte("down", (byte)this.status[0].ordinal());
        tagCompound.putByte("up", (byte)this.status[1].ordinal());
        tagCompound.putByte("north", (byte)this.status[2].ordinal());
        tagCompound.putByte("south", (byte)this.status[3].ordinal());
        tagCompound.putByte("west", (byte)this.status[4].ordinal());
        tagCompound.putByte("east", (byte)this.status[5].ordinal());
        tagCompound.putBoolean("showRenderBox", this.showRenderBox);
        tagCompound.putInt("offsetX", this.offsetX);
        tagCompound.putInt("offsetY", this.offsetY);
        tagCompound.putInt("offsetZ", this.offsetZ);
        this.tank.writeToNBT(registries, tagCompound);
    }

    public EnumStatus getSideStatus(Direction side) {
        return this.status[side.ordinal()];
    }

    public void toggleMode(Direction side) {
        switch (this.status[side.ordinal()].ordinal()) {
            case 0: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_ITEM;
                break;
            }
            case 1: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_FLUID;
                break;
            }
            case 2: {
                this.status[side.ordinal()] = EnumStatus.STATUS_NONE;
            }
        }
        this.setChanged();
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.setChanged();
    }

    public void toggleOffset(int direction) {
        switch (direction) {
            case 7: {
                if (this.getoffsetY() < -3 - this.getModifierAmount()) break;
                this.offsetY = this.getoffsetY() - 1;
                break;
            }
            case 8: {
                if (this.getoffsetY() > 3 + this.getModifierAmount()) break;
                this.offsetY = this.getoffsetY() + 1;
                break;
            }
            case 9: {
                if (this.getoffsetZ() < -3 - this.getModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() - 1;
                break;
            }
            case 10: {
                if (this.getoffsetZ() > 3 + this.getModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() + 1;
                break;
            }
            case 11: {
                if (this.getoffsetX() < -3 - this.getModifierAmount()) break;
                this.offsetX = this.getoffsetX() - 1;
                break;
            }
            case 12: {
                if (this.getoffsetX() > 3 + this.getModifierAmount()) break;
                this.offsetX = this.getoffsetX() + 1;
            }
        }
        this.setChanged();
    }

    public void updateBlock() {
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityAbsorptionHopper) {
            TileEntityAbsorptionHopper tile = (TileEntityAbsorptionHopper)t;
            tile.prevTankAmount = tile.tank.getFluidAmount();
            for (Direction facing : Direction.values()) {
                if (tile.status[facing.ordinal()] == EnumStatus.STATUS_OUTPUT_ITEM) {
                    BlockEntity otherTile = level.getBlockEntity(worldPosition.relative(facing));
                    Optional<IItemHandler> handlerOptional = CapHelper.getItemHandler(level, worldPosition.relative(facing), facing.getOpposite());
                    if (otherTile != null && handlerOptional.isPresent()) {
                        handlerOptional.ifPresent(handler -> {
                            if (level.getGameTime() % 8L == 0L) {
                                for (int i = 0; i < tile.getContainerSize(); ++i) {
                                    if (tile.getItem(i).isEmpty() || i == 0) continue;
                                    ItemStack stack = tile.getItem(i).copy();
                                    stack.setCount(1);
                                    ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                                    if (!stack1.isEmpty()) continue;
                                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)tile.removeItem(i, 1), (boolean)false);
                                    tile.setChanged();
                                }
                            }
                        });
                    } else if (otherTile instanceof Container) {
                        Container iinventory = (Container)otherTile;
                        if (tile.isInventoryFull(iinventory, facing)) break;
                        if (level.getGameTime() % 8L == 0L) {
                            for (int i = 0; i < tile.getContainerSize(); ++i) {
                                if (tile.getItem(i).isEmpty() || i == 0) continue;
                                ItemStack stack = tile.getItem(i).copy();
                                ItemStack stack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(iinventory, tile.removeItem(i, 1), facing.getOpposite());
                                if (stack1.isEmpty() || stack1.getCount() == 0) {
                                    iinventory.setChanged();
                                    continue;
                                }
                                tile.setItem(i, stack);
                            }
                        }
                    }
                }
                if (tile.status[facing.ordinal()] != EnumStatus.STATUS_OUTPUT_FLUID) continue;
                Optional<IFluidHandler> handlerOptional = CapHelper.getFluidHandler(level, worldPosition.relative(facing), facing.getOpposite());
                handlerOptional.ifPresent(receptacle -> {
                    int tanks = receptacle.getTanks();
                    for (int x = 0; x < tanks; ++x) {
                        if (receptacle.getTankCapacity(x) <= 0) continue;
                        FluidStack contents = receptacle.getFluidInTank(x);
                        if (tile.tank.getFluid().isEmpty() || !contents.isEmpty() && (contents.getAmount() > receptacle.getTankCapacity(x) - 100 || !contents.is(tile.tank.getFluid().getFluid()))) continue;
                        receptacle.fill(tile.tank.drain(new FluidStack(tile.tank.getFluid().getFluid(), 100), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                        tile.setChanged();
                    }
                });
            }
            if (level.getGameTime() % 3L == 0L && !level.hasNeighborSignal(worldPosition)) {
                if (!tile.isInventoryFull((Container)tile, null)) {
                    tile.captureDroppedItems();
                }
                if (tile.tank.getFluid().isEmpty() || tile.tank.getFluid().is((Fluid)ModBlocks.FLUID_XP.get())) {
                    tile.captureDroppedXP();
                }
            }
            if (tile.prevTankAmount != tile.tank.getFluidAmount()) {
                tile.updateBlock();
            }
        }
    }

    @Override
    @Nullable
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.getItems(), (int)index, (int)count);
    }

    public boolean captureDroppedItems() {
        for (ItemEntity entityitem : this.getCaptureItems()) {
            if (!TileEntityAbsorptionHopper.putDropInInventoryAllSlots((Container)this, entityitem)) continue;
            return true;
        }
        return false;
    }

    public List<ItemEntity> getCaptureItems() {
        return this.getLevel().getEntitiesOfClass(ItemEntity.class, this.getAABBWithModifiers(), EntitySelector.ENTITY_STILL_ALIVE);
    }

    public boolean captureDroppedXP() {
        Iterator<ExperienceOrb> iterator = this.getCaptureXP().iterator();
        if (iterator.hasNext()) {
            ExperienceOrb entity = iterator.next();
            int xpAmount = entity.getValue();
            if (this.tank.getFluidAmount() < this.tank.getCapacity() - xpAmount * 20) {
                this.tank.fill(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), xpAmount * 20), IFluidHandler.FluidAction.EXECUTE);
                entity.value = 0;
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public List<ExperienceOrb> getCaptureXP() {
        return this.getLevel().getEntitiesOfClass(ExperienceOrb.class, this.getAABBWithModifiers(), EntitySelector.ENTITY_STILL_ALIVE);
    }

    public AABB getAABBWithModifiers() {
        double x = (double)this.getBlockPos().getX() + 0.5;
        double y = (double)this.getBlockPos().getY() + 0.5;
        double z = (double)this.getBlockPos().getZ() + 0.5;
        return new AABB(x - 3.5 - (double)this.getModifierAmount(), y - 3.5 - (double)this.getModifierAmount(), z - 3.5 - (double)this.getModifierAmount(), x + 3.5 + (double)this.getModifierAmount(), y + 3.5 + (double)this.getModifierAmount(), z + 3.5 + (double)this.getModifierAmount()).move((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getAABBForRender() {
        return new AABB(-3.0 - (double)this.getModifierAmount(), -3.0 - (double)this.getModifierAmount(), -3.0 - (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount()).move((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    public int getoffsetX() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetX, 4 + this.getModifierAmount()));
    }

    public int getoffsetY() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetY, 4 + this.getModifierAmount()));
    }

    public int getoffsetZ() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetZ, 4 + this.getModifierAmount()));
    }

    private boolean hasUpgrade() {
        return !((ItemStack)this.getItems().get(0)).isEmpty() && ((ItemStack)this.getItems().get(0)).getItem() == ModItems.ABSORPTION_UPGRADE.get();
    }

    public int getModifierAmount() {
        return this.hasUpgrade() ? ((ItemStack)this.getItems().get(0)).getCount() : 0;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.getItems(), (int)index);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot != 0;
    }

    @Nonnull
    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction direction) {
        return slot != 0;
    }

    private boolean isInventoryFull(Container inventoryIn, Direction side) {
        if (inventoryIn instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventoryIn;
            for (int k : aint = isidedinventory.getSlotsForFace(side)) {
                ItemStack itemstack1 = isidedinventory.getItem(k);
                if (!itemstack1.isEmpty() && itemstack1.getCount() == itemstack1.getMaxStackSize()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.getContainerSize();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.getItem(j);
                if (!itemstack.isEmpty() && itemstack.getCount() == itemstack.getMaxStackSize()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(Container inventory, ItemStack stack, @Nullable Direction facing) {
        if (inventory instanceof WorldlyContainer && facing != null && !(inventory instanceof TileEntityAbsorptionHopper) && inventory.canPlaceItem(0, stack.copy())) {
            WorldlyContainer isidedinventory = (WorldlyContainer)inventory;
            int[] aint = isidedinventory.getSlotsForFace(facing);
            for (int k = 0; k < aint.length && !stack.isEmpty(); ++k) {
                stack = TileEntityAbsorptionHopper.insertStack(inventory, stack, aint[k], facing);
            }
        } else {
            int i = inventory.getContainerSize();
            for (int j = 0; j < i && !stack.isEmpty(); ++j) {
                stack = TileEntityAbsorptionHopper.insertStack(inventory, stack, j, facing);
            }
        }
        return stack;
    }

    public static boolean putDropInInventoryAllSlots(Container inventoryIn, ItemEntity itemIn) {
        boolean flag = false;
        if (itemIn == null || inventoryIn instanceof TileEntityAbsorptionHopper && inventoryIn.canPlaceItem(0, itemIn.getItem().copy())) {
            return false;
        }
        ItemStack itemstack = itemIn.getItem().copy();
        ItemStack itemstack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(inventoryIn, itemstack, null);
        if (!itemstack1.isEmpty()) {
            itemIn.setItem(itemstack1);
        } else {
            flag = true;
            itemIn.remove(Entity.RemovalReason.DISCARDED);
        }
        return flag;
    }

    private static boolean canInsertItemInSlot(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return inventoryIn.canPlaceItem(index, stack) && (!(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).canPlaceItemThroughFace(index, stack, side));
    }

    private static ItemStack insertStack(Container inventory, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventory.getItem(index);
        if (TileEntityAbsorptionHopper.canInsertItemInSlot(inventory, stack, index, side)) {
            if (itemstack.isEmpty()) {
                inventory.setItem(index, stack);
                stack = ItemStack.EMPTY;
            } else if (TileEntityAbsorptionHopper.canCombine(itemstack, stack)) {
                int i = stack.getMaxStackSize() - itemstack.getCount();
                int j = Math.min(stack.getCount(), i);
                stack.shrink(j);
                itemstack.grow(j);
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() != stack2.getItem() ? false : (stack1.getDamageValue() != stack2.getDamageValue() ? false : (stack1.getCount() > stack1.getMaxStackSize() ? false : ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2)));
    }

    protected IItemHandler createUnSidedHandler() {
        return new InventoryWrapperAH((Container)this);
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player player) {
        return new ContainerAbsorptionHopper(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)"block.mob_grinding_utils.absorption_hopper");
    }

    public static enum EnumStatus implements StringRepresentable
    {
        STATUS_NONE("none"),
        STATUS_OUTPUT_ITEM("item"),
        STATUS_OUTPUT_FLUID("fluid");

        private final String name;

        private EnumStatus(String name) {
            this.name = name;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }
    }
}

