/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.itemblocks;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MGUBlockItem
extends BlockItem {
    private final Block block;

    public MGUBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
        this.block = blockIn;
    }

    private boolean addTooltipLine(int line, List<Component> tooltip) {
        if (I18n.exists((String)(this.block.getDescriptionId() + ".tooltip_" + line))) {
            tooltip.add((Component)Component.translatable((String)(this.block.getDescriptionId() + ".tooltip_" + line)).withStyle(ChatFormatting.YELLOW));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        for (int i = 1; i <= 6 && this.addTooltipLine(i, tooltip); ++i) {
        }
    }
}

