/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class MGUBlockReg<B extends Block, I extends Item, T extends BlockEntity>
implements Supplier<B> {
    private final String name;
    private final DeferredBlock<B> block;
    private final DeferredItem<I> item;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> tile;

    @Override
    public B get() {
        return (B)((Block)this.block.get());
    }

    public String getName() {
        return this.name;
    }

    public MGUBlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier, BlockEntityType.BlockEntitySupplier<T> tileSupplier) {
        this.name = name;
        this.block = ModBlocks.BLOCKS.register(name, blockSupplier);
        this.item = ModItems.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
        this.tile = ModBlocks.TILE_ENTITIES.register(name, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)tileSupplier, (Block[])new Block[]{(Block)this.block.get()}).build(null));
    }

    public MGUBlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier) {
        this.name = name;
        this.block = ModBlocks.BLOCKS.register(name, blockSupplier);
        this.item = ModItems.ITEMS.register(name, () -> (Item)itemSupplier.apply((Block)this.block.get()));
    }

    @Nonnull
    public B getBlock() {
        return (B)((Block)this.block.get());
    }

    @Nonnull
    public I getItem() {
        return (I)((Item)this.item.get());
    }

    @Nonnull
    public BlockEntityType<T> getTileEntityType() {
        return (BlockEntityType)Objects.requireNonNull(this.tile).get();
    }
}

