/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.client;

import java.awt.Rectangle;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import mcjty.rftoolspower.modules.monitor.blocks.PowerMonitorTileEntity;
import mcjty.rftoolspower.modules.monitor.data.PowerMonitorData;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class GuiPowerMonitor
extends GenericGuiContainer<PowerMonitorTileEntity, GenericContainer> {
    public GuiPowerMonitor(GenericContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)MonitorModule.POWER_MONITOR.block().get()).getManualEntry());
        this.imageWidth = 256;
        this.imageHeight = 50;
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(MonitorModule.CONTAINER_POWER_MONITOR.get(), GuiPowerMonitor::new);
    }

    public void init() {
        super.init();
        PowerMonitorTileEntity tileEntity = (PowerMonitorTileEntity)this.getBE();
        ScrollableLabel minimumLabel = ((ScrollableLabel)((ScrollableLabel)new ScrollableLabel().name("minimum")).suffix("%").desiredWidth(30)).realMinimum(0).realMaximum(100);
        Slider mininumSlider = ((Slider)((Slider)new Slider().desiredHeight(15)).horizontal().minimumKnobSize(15).tooltips(new String[]{"Minimum level"})).scrollableName("minimum");
        Panel minimumPanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{Widgets.label((String)"Min:").desiredWidth(30), mininumSlider, minimumLabel})).desiredHeight(20);
        ScrollableLabel maximumLabel = ((ScrollableLabel)((ScrollableLabel)new ScrollableLabel().name("maximum")).suffix("%").desiredWidth(30)).realMinimum(0).realMaximum(100);
        Slider maximumSlider = ((Slider)((Slider)new Slider().desiredHeight(15)).horizontal().minimumKnobSize(15).tooltips(new String[]{"Maximum level"})).scrollableName("maximum");
        Panel maximumPanel = (Panel)((Panel)Widgets.horizontal().children(new Widget[]{Widgets.label((String)"Max:").desiredWidth(30), maximumSlider, maximumLabel})).desiredHeight(20);
        Panel toplevel = (Panel)((Panel)Widgets.vertical().filledRectThickness(2)).children(new Widget[]{minimumPanel, maximumPanel});
        toplevel.setBounds(new Rectangle(this.leftPos, this.topPos, this.imageWidth, this.imageHeight));
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        PowerMonitorData monitorData = (PowerMonitorData)((GenericContainer)this.menu).getAttachmentData(MonitorModule.POWER_MONITOR_DATA.get());
        minimumLabel.realValue((int)monitorData.minimum());
        maximumLabel.realValue((int)monitorData.maximum());
        this.window.bindData("minimum", "minimum", (GenericTileEntity)tileEntity, MonitorModule.POWER_MONITOR_DATA.get());
        this.window.bindData("maximum", "maximum", (GenericTileEntity)tileEntity, MonitorModule.POWER_MONITOR_DATA.get());
    }
}

