/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.generator.blocks;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.generator.CoalGeneratorConfig;
import mcjty.rftoolspower.modules.generator.CoalGeneratorModule;
import mcjty.rftoolspower.modules.generator.data.CoalGeneratorData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;

public class CoalGeneratorTileEntity
extends TickingTileEntity {
    public static final int SLOT_COALINPUT = 0;
    public static final int SLOT_CHARGEITEM = 1;
    private static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(CoalGeneratorTileEntity::isValidFuel).in(), 0, 82, 24).slot(SlotDefinition.specific(EnergyTools::isEnergyItem).in().out(), 1, 118, 24).playerSlots(10, 70));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 0) {
            return CoalGeneratorTileEntity.isValidFuel(stack);
        }
        return EnergyTools.isEnergyItem((ItemStack)stack);
    }).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<CoalGeneratorTileEntity, GenericItemHandler> ITEM_CAP = tile -> tile.items;
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)CoalGeneratorConfig.MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.ENERGY)
    private static final Function<CoalGeneratorTileEntity, GenericEnergyStorage> ENERGY_CAP = tile -> tile.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<CoalGeneratorTileEntity, MenuProvider> SCREEN_CAP = be -> new DefaultContainerProvider("Coal Generator").containerSupplier(DefaultContainerProvider.container(CoalGeneratorModule.CONTAINER_COALGENERATOR, CONTAINER_FACTORY, (GenericTileEntity)be)).itemHandler(() -> be.items).energyHandler(() -> be.energyStorage).setupSync((GenericTileEntity)be);
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<CoalGeneratorTileEntity, IInfusable> INFUSABLE_CAP = tile -> tile.infusable;
    private final IPowerInformation powerInfoHandler = this.createPowerInfo();
    @Cap(type=CapType.POWER_INFO)
    private static final Function<CoalGeneratorTileEntity, IPowerInformation> POWER_INFO_CAP = tile -> tile.powerInfoHandler;

    public CoalGeneratorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CoalGeneratorModule.COALGENERATOR.be().get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(CoalGeneratorTileEntity::new).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbase:powergeneration/coalgenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", stack -> String.valueOf(CoalGeneratorConfig.RFPERTICK.get()) + " RF/FE")})){

            protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.createBlockStateDefinition(builder);
                builder.add(new Property[]{BlockStateProperties.LIT});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.setChanged();
        }
    }

    protected void tickServer() {
        this.markDirtyQuick();
        this.handleChargingItem((IItemHandler)this.items);
        this.handleSendingEnergy();
        if (!this.isMachineEnabled()) {
            return;
        }
        this.handlePowerGeneration();
    }

    private void handlePowerGeneration() {
        CoalGeneratorData data = (CoalGeneratorData)this.getData(CoalGeneratorModule.COAL_GENERATOR_DATA);
        int burning = data.burning();
        if (burning > 0) {
            --burning;
            long rf = this.getRfPerTick();
            this.energyStorage.produceEnergy(rf);
        } else if (!this.items.getStackInSlot(0).isEmpty()) {
            ItemStack extracted = this.items.extractItem(0, 1, false);
            burning = (Integer)CoalGeneratorConfig.TICKSPERCOAL.get();
            if (extracted.getItem() == Blocks.COAL_BLOCK.asItem()) {
                burning *= 9;
            }
            float factor = this.infusable.getInfusedFactor();
            burning += (int)((float)burning * factor / 2.0f);
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() != this.isWorking()) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.isWorking())), 3);
        }
        data = data.withBurning(burning);
        this.setData(CoalGeneratorModule.COAL_GENERATOR_DATA, data);
    }

    public long getRfPerTick() {
        long rf = ((Integer)CoalGeneratorConfig.RFPERTICK.get()).intValue();
        float factor = this.infusable.getInfusedFactor();
        rf += (long)((float)rf * factor);
        return rf;
    }

    public boolean isWorking() {
        return ((CoalGeneratorData)this.getData(CoalGeneratorModule.COAL_GENERATOR_DATA)).burning() > 0 && this.isMachineEnabled();
    }

    private void handleChargingItem(IItemHandler handler) {
        ItemStack stack = handler.getStackInSlot(1);
        if (!stack.isEmpty()) {
            long storedPower = this.energyStorage.getEnergy();
            long rfToGive = Math.min((long)((Integer)CoalGeneratorConfig.CHARGEITEMPERTICK.get()).intValue(), storedPower);
            long received = EnergyTools.receiveEnergy((ItemStack)stack, (long)rfToGive);
            this.energyStorage.consumeEnergy(received);
        }
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((Level)this.level, (BlockPos)this.worldPosition, (long)storedPower, (long)((Integer)CoalGeneratorConfig.SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
        this.infusable.save(tag, "infusable");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
        this.infusable.load(tag, "infusable");
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        CoalGeneratorData data = (CoalGeneratorData)input.get(CoalGeneratorModule.ITEM_COAL_GENERATOR_DATA);
        if (data != null) {
            this.setData(CoalGeneratorModule.COAL_GENERATOR_DATA, data);
        }
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(CoalGeneratorModule.ITEM_COAL_GENERATOR_DATA, (Object)((CoalGeneratorData)this.getData(CoalGeneratorModule.COAL_GENERATOR_DATA)));
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return ((CoalGeneratorData)CoalGeneratorTileEntity.this.getData(CoalGeneratorModule.COAL_GENERATOR_DATA)).burning() > 0 ? CoalGeneratorTileEntity.this.getRfPerTick() : 0L;
            }

            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public boolean isMachineRunning() {
                return CoalGeneratorTileEntity.this.isMachineEnabled();
            }

            public String getMachineStatus() {
                return ((CoalGeneratorData)CoalGeneratorTileEntity.this.getData(CoalGeneratorModule.COAL_GENERATOR_DATA)).burning() > 0 ? "generating power" : "idle";
            }
        };
    }

    private static boolean isValidFuel(@Nonnull ItemStack stack) {
        return stack.getItem() == Items.COAL || stack.getItem() == Items.CHARCOAL || stack.getItem() == Items.COAL_BLOCK;
    }
}

