/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.valhelsia.valhelsia_core.api.common.helper.FlintAndSteelHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlintAndSteelItem.class})
public class FlintAndSteelItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    private void valhelsia_useOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        for (FlintAndSteelHelper.FlintAndSteelUse use : FlintAndSteelHelper.getUses()) {
            if (!use.unlitState().test(state)) continue;
            if (use.useEffect() != null) {
                use.useEffect().playEffect(player, level, pos);
            }
            level.setBlockAndUpdate(pos, use.litState().apply(state));
            if (player != null) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
            cir.setReturnValue((Object)use.resultType().getResult(level));
        }
    }
}

