/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry.helper.item;

import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.helper.DefaultRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.item.ItemEntrySet;
import net.valhelsia.valhelsia_core.api.common.registry.helper.item.ItemRegistryEntry;

public class ItemRegistryHelper
extends DefaultRegistryHelper<Item> {
    public ItemRegistryHelper(ResourceKey<? extends Registry<Item>> registry, String modId, ImmutableList<Class<?>> registryClasses) {
        super(registry, modId, registryClasses);
    }

    @Override
    protected <O extends Item> RegistryEntry<Item, O> createEntry(ResourceKey<Item> key) {
        return new ItemRegistryEntry(key);
    }

    public <O extends Item> ItemRegistryEntry<O> register(String name, Supplier<O> object) {
        return (ItemRegistryEntry)super.registerInternal(name, object);
    }

    public void registerBlockItems(BlockRegistryHelper registryHelper) {
        registryHelper.getRegistryEntries().forEach(entry -> {
            BlockRegistryEntry blockEntry;
            if (entry instanceof BlockRegistryEntry && (blockEntry = (BlockRegistryEntry)entry).getItemFunction() != null) {
                this.register(blockEntry.getName(), () -> blockEntry.getItemFunction().apply(blockEntry));
            }
        });
    }

    public <T extends Item> ItemEntrySet<T, DyeColor> registerColorEntrySet(String name, Function<DyeColor, T> function) {
        return this.registerEntrySet(DyeColor.class, name, function);
    }

    public <T extends Item> ItemEntrySet<T, DyeColor> registerColorEntrySet(UnaryOperator<String> name, Function<DyeColor, T> function) {
        return this.registerEntrySet(DyeColor.class, name, function);
    }

    public <T extends Item> ItemEntrySet<T, DyeColor> registerColorEntrySet(String name, Function<DyeColor, T> function, UnaryOperator<ItemRegistryEntry<T>> unaryOperator) {
        return this.registerEntrySet(DyeColor.class, name, function, unaryOperator);
    }

    public <T extends Item> ItemEntrySet<T, DyeColor> registerColorEntrySet(UnaryOperator<String> name, Function<DyeColor, T> function, UnaryOperator<ItemRegistryEntry<T>> unaryOperator) {
        return this.registerEntrySet(DyeColor.class, name, function, unaryOperator);
    }

    public <K extends Enum<K>, T extends Item> ItemEntrySet<T, K> registerEntrySet(Class<K> keyType, String name, Function<K, T> function) {
        return this.registerEntrySet(keyType, s -> s + "_" + name, function);
    }

    public <K extends Enum<K>, T extends Item> ItemEntrySet<T, K> registerEntrySet(Class<K> keyType, UnaryOperator<String> name, Function<K, T> function) {
        ItemEntrySet set = new ItemEntrySet(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            set.put(key, this.register((String)name.apply(((StringRepresentable)key).getSerializedName()), () -> (Item)function.apply(key)));
        }
        return set;
    }

    public <K extends Enum<K>, T extends Item> ItemEntrySet<T, K> registerEntrySet(Class<K> keyType, String name, Function<K, T> function, UnaryOperator<ItemRegistryEntry<T>> unaryOperator) {
        return this.registerEntrySet(keyType, s -> s + "_" + name, function, unaryOperator);
    }

    public <K extends Enum<K>, T extends Item> ItemEntrySet<T, K> registerEntrySet(Class<K> keyType, UnaryOperator<String> name, Function<K, T> function, UnaryOperator<ItemRegistryEntry<T>> unaryOperator) {
        ItemEntrySet set = new ItemEntrySet(keyType);
        for (Enum key : (Enum[])keyType.getEnumConstants()) {
            set.put(key, (ItemRegistryEntry)unaryOperator.apply((ItemRegistryEntry<RegistryEntry>)this.register((String)name.apply(((StringRepresentable)key).getSerializedName()), () -> (Item)function.apply(key))));
        }
        return set;
    }
}

