/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.registry;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryEntry<R, T extends R>
implements Holder<R>,
Supplier<T> {
    protected final ResourceKey<R> key;
    @Nullable
    private Holder<R> holder = null;

    public RegistryEntry(ResourceKey<R> key) {
        this.key = key;
        this.bind();
    }

    @Override
    public T get() {
        return this.value();
    }

    private void bind() {
        if (this.holder != null) {
            return;
        }
        Optional.ofNullable((Registry)BuiltInRegistries.REGISTRY.get(this.key.registry())).flatMap(objects -> objects.getHolder(this.key)).ifPresent(reference -> {
            this.holder = reference;
        });
    }

    @NotNull
    public T value() {
        this.bind();
        return (T)Optional.ofNullable(this.holder).map(Holder::value).orElseThrow(() -> new IllegalStateException("Registry entry for key " + String.valueOf(this.key) + " is not bound."));
    }

    public boolean isBound() {
        this.bind();
        return this.holder != null && this.holder.isBound();
    }

    public boolean is(ResourceLocation location) {
        this.bind();
        return location.equals((Object)this.key.location());
    }

    public boolean is(ResourceKey<R> resourceKey) {
        this.bind();
        return resourceKey.equals(this.key);
    }

    public boolean is(Predicate<ResourceKey<R>> predicate) {
        this.bind();
        return predicate.test(this.key);
    }

    public boolean is(TagKey<R> tagKey) {
        this.bind();
        return this.holder != null && this.holder.is(tagKey);
    }

    public boolean is(Holder<R> holder) {
        this.bind();
        return this.holder != null && this.holder.is(holder);
    }

    @NotNull
    public Stream<TagKey<R>> tags() {
        this.bind();
        return this.holder != null ? this.holder.tags() : Stream.empty();
    }

    @NotNull
    public Either<ResourceKey<R>, R> unwrap() {
        return Either.left(this.key);
    }

    @NotNull
    public Optional<ResourceKey<R>> unwrapKey() {
        return Optional.of(this.key);
    }

    @NotNull
    public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    public boolean canSerializeIn(HolderOwner<R> owner) {
        this.bind();
        return this.holder != null && this.holder.canSerializeIn(owner);
    }

    public boolean equals(Object obj) {
        Holder h;
        if (this == obj) {
            return true;
        }
        return obj instanceof Holder && (h = (Holder)obj).kind() == Holder.Kind.REFERENCE && h.unwrapKey().orElseThrow() == this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

