/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.structure.garden;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.LunarVineBlock;
import cn.leolezury.eternalstarlight.common.block.ShadegrieveBlock;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESStructurePieceTypes;
import cn.leolezury.eternalstarlight.common.util.MazeGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class CursedGardenMazePiece
extends StructurePiece {
    private static final int MAZE_SIZE = 37;
    private static final int STRUCTURE_SIZE = 111;
    private static final int STRUCTURE_HEIGHT = 12;
    private static final int CENTER_SIZE = 20;
    private static final int LUNAR_VINE_SIZE = 21;
    private static final Set<Direction> HORIZONTAL_DIRECTIONS = Set.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);
    private final StructureTemplate noConnection;
    private final StructureTemplate singleConnection;
    private final StructureTemplate doubleConnectionStraight;
    private final StructureTemplate doubleConnectionCorner;
    private final StructureTemplate tripleConnection;
    private final StructureTemplate allConnection;
    private boolean[][] maze = new boolean[37][37];

    public CursedGardenMazePiece(StructureTemplateManager templateManager, long seed, int x, int y, int z) {
        super(ESStructurePieceTypes.CURSED_GARDEN_MAZE.get(), 0, new BoundingBox(x - 55, y - 1, z - 55, x + 55, y + 12, z + 55));
        this.setOrientation(Direction.SOUTH);
        this.noConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_no_connection"));
        this.singleConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_single_connection"));
        this.doubleConnectionStraight = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_double_connection_straight"));
        this.doubleConnectionCorner = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_double_connection_corner"));
        this.tripleConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_triple_connection"));
        this.allConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_all_connection"));
        MazeGenerator mazeGenerator = new MazeGenerator(37, RandomSource.create((long)(seed + new BlockPos(x, y, z).asLong())));
        this.maze = mazeGenerator.generateMaze(1, 1);
        this.maze[0][18] = false;
        this.maze[1][18] = false;
        this.maze[18][0] = false;
        this.maze[18][1] = false;
        this.maze[36][18] = false;
        this.maze[35][18] = false;
        this.maze[18][36] = false;
        this.maze[18][35] = false;
        for (int i = 0; i < 37; ++i) {
            for (int j = 0; j < 37; ++j) {
                if (!(Math.pow((double)(i * 3 + 1) - 55.5, 2.0) + Math.pow((double)(j * 3 + 1) - 55.5, 2.0) < 400.0)) continue;
                this.maze[i][j] = false;
            }
        }
    }

    public CursedGardenMazePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(ESStructurePieceTypes.CURSED_GARDEN_MAZE.get(), tag);
        this.setOrientation(Direction.SOUTH);
        StructureTemplateManager templateManager = context.structureTemplateManager();
        this.noConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_no_connection"));
        this.singleConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_single_connection"));
        this.doubleConnectionStraight = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_double_connection_straight"));
        this.doubleConnectionCorner = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_double_connection_corner"));
        this.tripleConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_triple_connection"));
        this.allConnection = templateManager.getOrCreate(EternalStarlight.id("cursed_garden/maze_all_connection"));
        ListTag xTag = tag.getList("maze", 9);
        for (int x = 0; x < 37; ++x) {
            Tag yTag;
            if (x >= xTag.size() || !((yTag = xTag.get(x)) instanceof ListTag)) continue;
            ListTag yList = (ListTag)yTag;
            for (int y = 0; y < 37; ++y) {
                Tag tag2;
                if (y >= yList.size() || !((tag2 = yList.get(y)) instanceof ByteTag)) continue;
                ByteTag byteTag = (ByteTag)tag2;
                this.maze[x][y] = byteTag.getAsByte() != 0;
            }
        }
    }

    protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag tag) {
        ListTag xTag = new ListTag();
        for (int x = 0; x < 37; ++x) {
            ListTag yTag = new ListTag();
            for (int y = 0; y < 37; ++y) {
                yTag.add((Object)ByteTag.valueOf((boolean)this.maze[x][y]));
            }
            xTag.add((Object)yTag);
        }
        tag.put("maze", (Tag)xTag);
    }

    public void postProcess(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        for (int x = 0; x < 37; ++x) {
            for (int z = 0; z < 37; ++z) {
                if (this.maze[x][z]) {
                    BlockPos.MutableBlockPos pillarPos = this.getWorldPos(x * 3, 1, z * 3);
                    HashSet<Direction> connectedDirs = new HashSet<Direction>();
                    for (Direction direction : HORIZONTAL_DIRECTIONS) {
                        int connectedX = x + direction.getStepX();
                        int connectedZ = z + direction.getStepZ();
                        if (connectedX < 0 || connectedX >= 37 || connectedZ < 0 || connectedZ >= 37 || !this.maze[connectedX][connectedZ]) continue;
                        connectedDirs.add(direction);
                    }
                    switch (connectedDirs.size()) {
                        case 0: {
                            this.noConnection.placeInWorld((ServerLevelAccessor)level, (BlockPos)pillarPos, (BlockPos)pillarPos, new StructurePlaceSettings().setBoundingBox(box), random, 2);
                            break;
                        }
                        case 1: {
                            connectedDirs.stream().findFirst().ifPresent(arg_0 -> this.lambda$postProcess$0(level, (BlockPos)pillarPos, box, random, arg_0));
                            break;
                        }
                        case 2: {
                            connectedDirs.stream().findFirst().ifPresent(arg_0 -> this.lambda$postProcess$3(connectedDirs, level, (BlockPos)pillarPos, box, random, arg_0));
                            break;
                        }
                        case 3: {
                            new HashSet<Direction>(HORIZONTAL_DIRECTIONS).stream().filter(d -> !connectedDirs.contains(d)).findFirst().ifPresent(arg_0 -> this.lambda$postProcess$5(level, (BlockPos)pillarPos, box, random, arg_0));
                            break;
                        }
                        case 4: {
                            this.allConnection.placeInWorld((ServerLevelAccessor)level, (BlockPos)pillarPos, (BlockPos)pillarPos, new StructurePlaceSettings().setBoundingBox(box), random, 2);
                        }
                    }
                }
                for (int blockX = x * 3; blockX < x * 3 + 3; ++blockX) {
                    for (int blockZ = z * 3; blockZ < z * 3 + 3; ++blockZ) {
                        this.placeBlock(level, x != 0 && x != 36 && z != 0 && z != 36 ? ESBlocks.TENACIOUS_NIGHTFALL_GRASS_BLOCK.get().defaultBlockState() : ESBlocks.GRIMSTONE_BRICKS.get().defaultBlockState(), blockX, 0, blockZ, box);
                        if (this.maze[x][z]) {
                            int leavesHeight = 3 + random.nextInt(3);
                            for (int y = 0; y < 11; ++y) {
                                this.placeBlock(level, y <= leavesHeight && x != 0 && x != 36 && z != 0 && z != 36 ? (BlockState)(random.nextInt(3) == 0 ? ESBlocks.BLOOMING_SHADEGRIEVE.get() : ESBlocks.SHADEGRIEVE.get()).defaultBlockState().setValue((Property)ShadegrieveBlock.TOP, (Comparable)Boolean.valueOf(y == leavesHeight)) : (y == 10 ? ESBlocks.GRIMSTONE_TILE_SLAB.get().defaultBlockState() : ESBlocks.GRIMSTONE_BRICKS.get().defaultBlockState()), blockX, y + 2, blockZ, box);
                            }
                            continue;
                        }
                        for (int y = 0; y < 12; ++y) {
                            this.placeBlock(level, Blocks.AIR.defaultBlockState(), blockX, y + 1, blockZ, box);
                        }
                    }
                }
            }
        }
        this.placeBlock(level, ESBlocks.LUNAR_MONSTROSITY_SPAWNER.get().defaultBlockState(), 55, 1, 55, box);
        ArrayList<BlockPos> chestPositions = new ArrayList<BlockPos>();
        for (int x = 1; x < 111; ++x) {
            for (int z = 1; z < 111; ++z) {
                if (this.getBlock((BlockGetter)level, x, 1, z, box).isAir() || this.getBlock((BlockGetter)level, x, 1, z, box).is(Blocks.VINE) || this.getBlock((BlockGetter)level, x, 1, z, box).is((Block)ESBlocks.LUNAR_VINE.get())) continue;
                for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
                    int vineZ;
                    int vineX = x + direction.getStepX();
                    if (!this.getBlock((BlockGetter)level, vineX, 1, vineZ = z + direction.getStepZ(), box).isAir()) continue;
                    double distSqr = Math.pow((double)vineX - 55.5, 2.0) + Math.pow((double)vineZ - 55.5, 2.0);
                    boolean lunarVines = distSqr < 441.0;
                    boolean bossRoom = distSqr < 400.0;
                    int yTo = 12 - random.nextInt(8) - 1;
                    int yFrom = random.nextInt(yTo - 3) + 2;
                    direction = direction.getAxis() == Direction.Axis.X ? direction.getOpposite() : direction;
                    for (int y = yFrom; y < yTo; ++y) {
                        if (!this.getBlock((BlockGetter)level, vineX, y, vineZ, box).isAir() || !this.getBlock((BlockGetter)level, x, y, z, box).is(ESBlocks.GRIMSTONE_BRICKS.get()) && !this.getBlock((BlockGetter)level, x, y, z, box).is((Block)ESBlocks.SHADEGRIEVE.get())) continue;
                        this.placeBlock(level, lunarVines ? (BlockState)ESBlocks.LUNAR_VINE.get().defaultBlockState().setValue((Property)LunarVineBlock.FACING, (Comparable)direction) : (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true)), vineX, y, vineZ, box);
                    }
                    if (bossRoom || random.nextInt(45) != 0 || !chestPositions.stream().noneMatch(pos -> new BlockPos(vineX, 1, vineZ).distSqr((Vec3i)pos) <= 100.0)) continue;
                    chestPositions.add(new BlockPos(vineX, 1, vineZ));
                    this.createChest(level, box, random, vineX, 1, vineZ, ESLootTables.CHEST_CURSED_GARDEN);
                }
            }
        }
    }

    private /* synthetic */ void lambda$postProcess$5(WorldGenLevel level, BlockPos pillarPos, BoundingBox box, RandomSource random, Direction direction) {
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setBoundingBox(box);
        this.tripleConnection.placeInWorld((ServerLevelAccessor)level, pillarPos, pillarPos, structurePlaceSettings.setRotation(switch (Mth.wrapDegrees((int)((int)(direction.toYRot() - Direction.NORTH.toYRot())))) {
            case 90 -> Rotation.CLOCKWISE_90;
            case -180 -> Rotation.CLOCKWISE_180;
            case -90 -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        }).setRotationPivot(new BlockPos(1, 0, 1)), random, 2);
    }

    private /* synthetic */ void lambda$postProcess$3(Set connectedDirs, WorldGenLevel level, BlockPos pillarPos, BoundingBox box, RandomSource random, Direction direction) {
        if (connectedDirs.contains(direction.getOpposite())) {
            StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setBoundingBox(box);
            this.doubleConnectionStraight.placeInWorld((ServerLevelAccessor)level, pillarPos, pillarPos, structurePlaceSettings.setRotation(switch (Mth.wrapDegrees((int)((int)(direction.toYRot() - Direction.EAST.toYRot())))) {
                case 90 -> Rotation.CLOCKWISE_90;
                case -180 -> Rotation.CLOCKWISE_180;
                case -90 -> Rotation.COUNTERCLOCKWISE_90;
                default -> Rotation.NONE;
            }).setRotationPivot(new BlockPos(1, 0, 1)), random, 2);
        } else {
            connectedDirs.stream().max((o1, o2) -> (int)Math.signum(Mth.degreesDifference((float)o1.toYRot(), (float)o2.toYRot()))).ifPresent(dir -> {
                StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setBoundingBox(box);
                this.doubleConnectionCorner.placeInWorld((ServerLevelAccessor)level, pillarPos, pillarPos, structurePlaceSettings.setRotation(switch (Mth.wrapDegrees((int)((int)(dir.toYRot() - Direction.EAST.toYRot())))) {
                    case 90 -> Rotation.CLOCKWISE_90;
                    case -180 -> Rotation.CLOCKWISE_180;
                    case -90 -> Rotation.COUNTERCLOCKWISE_90;
                    default -> Rotation.NONE;
                }).setRotationPivot(new BlockPos(1, 0, 1)), random, 2);
            });
        }
    }

    private /* synthetic */ void lambda$postProcess$0(WorldGenLevel level, BlockPos pillarPos, BoundingBox box, RandomSource random, Direction direction) {
        StructurePlaceSettings structurePlaceSettings = new StructurePlaceSettings().setBoundingBox(box);
        this.singleConnection.placeInWorld((ServerLevelAccessor)level, pillarPos, pillarPos, structurePlaceSettings.setRotation(switch (Mth.wrapDegrees((int)((int)(direction.toYRot() - Direction.EAST.toYRot())))) {
            case 90 -> Rotation.CLOCKWISE_90;
            case -180 -> Rotation.CLOCKWISE_180;
            case -90 -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        }).setRotationPivot(new BlockPos(1, 0, 1)), random, 2);
    }
}

