/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class HugeMarimoldFeature
extends Feature<Configuration> {
    public HugeMarimoldFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        int y;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        ArrayList<BlockPos> stemBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> mushroomBlocks = new ArrayList<BlockPos>();
        int trunkHeight = config.trunkHeight().sample(random);
        int xzRadius = config.capRadius().sample(random);
        int foliageHeight = config.capHeight().sample(random);
        for (y = 0; y <= trunkHeight; ++y) {
            stemBlocks.add(pos.offset(0, y, 0));
        }
        mushroomBlocks.add(pos.offset(0, trunkHeight + 1, 0));
        for (y = 0; y >= -foliageHeight; --y) {
            int radiusNext;
            int radius = Mth.lerpInt((float)((float)(-y) / (float)foliageHeight), (int)0, (int)xzRadius);
            if (radius < (radiusNext = Mth.lerpInt((float)((float)(1 - y) / (float)foliageHeight), (int)0, (int)xzRadius))) {
                radius = random.nextInt(radius, radiusNext);
            }
            if (radius < 1) {
                radius = 1;
            }
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + z * z > radius * radius) continue;
                    mushroomBlocks.add(pos.offset(x, y + trunkHeight, z));
                }
            }
        }
        for (BlockPos blockPos : stemBlocks) {
            if (level.getBlockState(blockPos).is(Blocks.WATER)) continue;
            return false;
        }
        for (BlockPos blockPos : mushroomBlocks) {
            if (level.getBlockState(blockPos).is(Blocks.WATER)) continue;
            return false;
        }
        for (BlockPos blockPos : mushroomBlocks) {
            this.setBlock((LevelWriter)level, blockPos, ESBlocks.MARIMOLD_BLOCK.get().defaultBlockState());
        }
        for (BlockPos blockPos : stemBlocks) {
            this.setBlock((LevelWriter)level, blockPos, (BlockState)((BlockState)ESBlocks.MARIMOLD_STEM.get().defaultBlockState().setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(Direction.UP), (Comparable)Boolean.valueOf(blockPos.getY() - pos.getY() == trunkHeight))).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(Direction.DOWN), (Comparable)Boolean.valueOf(blockPos.getY() == pos.getY())));
        }
        return true;
    }

    public record Configuration(IntProvider trunkHeight, IntProvider capRadius, IntProvider capHeight) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("trunk_height").forGetter(Configuration::trunkHeight), (App)IntProvider.CODEC.fieldOf("cap_radius").forGetter(Configuration::capRadius), (App)IntProvider.CODEC.fieldOf("cap_height").forGetter(Configuration::capHeight)).apply((Applicative)instance, Configuration::new));
    }
}

