/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class CradlewoodFeature
extends Feature<Configuration> {
    public CradlewoodFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        List<BlockPos> farTop;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        ArrayList<BlockPos> trunkPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> leavesPositions = new ArrayList<BlockPos>();
        Configuration config = (Configuration)context.config();
        int height = config.height().sample(random);
        int horizontalOffset = config.horizontalOffset().sample(random);
        int leavesRadius = config.leavesRadius().sample(random);
        float angle = (float)random.nextInt(360) * ((float)Math.PI / 180);
        BlockPos targetPos = pos.offset((random.nextBoolean() ? 1 : -1) * (int)Math.round((double)horizontalOffset * Math.sin(angle)), 0, (random.nextBoolean() ? 1 : -1) * (int)Math.round((double)horizontalOffset * Math.cos(angle)));
        List<int[]> points = ESMathUtil.getBresenham3DPoints(pos.getX(), pos.getY() - height, pos.getZ(), targetPos.getX(), pos.getY() - height, targetPos.getZ());
        points.sort(Comparator.comparingInt(o -> (o[0] - pos.getX()) * (o[0] - pos.getX()) + (o[2] - pos.getZ()) * (o[2] - pos.getZ())));
        int horizontalLength = points.size();
        List<int[]> ellipsePoints = ESMathUtil.getBresenhamEllipsePoints(horizontalLength / 2, pos.getY(), horizontalLength / 2 + 1, height);
        ellipsePoints.removeIf(o -> o[1] > pos.getY());
        ellipsePoints.sort(Comparator.comparingInt(o -> o[0]));
        int i = 0;
        while (i < points.size()) {
            int[] point = points.get(i);
            int lineX = i++;
            ellipsePoints.stream().filter(o -> o[0] == lineX).forEach(o -> {
                BlockPos trunkPos = new BlockPos(point[0], o[1], point[2]);
                trunkPositions.add(trunkPos);
            });
        }
        List<BlockPos> nearTop = trunkPositions.stream().filter(o -> (o.getX() - pos.getX()) * (o.getX() - pos.getX()) + (o.getZ() - pos.getZ()) * (o.getZ() - pos.getZ()) < horizontalOffset / 2 * horizontalOffset / 2).sorted(Comparator.comparingInt(Vec3i::getY)).toList();
        if (!nearTop.isEmpty() && !points.isEmpty()) {
            int topY;
            for (int i2 = topY = nearTop.getLast().getY(); i2 <= pos.getY(); ++i2) {
                BlockPos extra = new BlockPos(points.getFirst()[0], i2, points.getFirst()[2]);
                if (trunkPositions.contains(extra)) continue;
                trunkPositions.add(extra);
            }
        }
        if (!(farTop = trunkPositions.stream().filter(o -> (o.getX() - pos.getX()) * (o.getX() - pos.getX()) + (o.getZ() - pos.getZ()) * (o.getZ() - pos.getZ()) > horizontalOffset / 2 * horizontalOffset / 2).sorted(Comparator.comparingInt(Vec3i::getY)).toList()).isEmpty()) {
            BlockPos endPos = farTop.getLast();
            trunkPositions.add(endPos.offset(1, 0, 1));
            trunkPositions.add(endPos.offset(1, 0, -1));
            trunkPositions.add(endPos.offset(-1, 0, 1));
            trunkPositions.add(endPos.offset(-1, 0, -1));
            for (int x = 0; x <= leavesRadius; ++x) {
                for (int z = 0; z <= leavesRadius; ++z) {
                    int y = 0;
                    while ((float)y <= (float)leavesRadius / 1.5f) {
                        if (ESMathUtil.isPointInOrOnEllipsoid(x, y, z, leavesRadius, (float)leavesRadius / 1.5f, leavesRadius)) {
                            for (int i3 = -1; i3 <= 1; i3 += 2) {
                                for (int j = -1; j <= 1; j += 2) {
                                    for (int k = -1; k <= 1; k += 2) {
                                        BlockPos leavesPos = endPos.offset(i3 * x, j * y, k * z);
                                        leavesPositions.add(leavesPos);
                                        for (Direction direction : Direction.values()) {
                                            if (random.nextInt(5) != 0) continue;
                                            leavesPositions.add(leavesPos.relative(direction));
                                        }
                                    }
                                }
                            }
                        }
                        ++y;
                    }
                }
            }
        }
        for (BlockPos trunkPos : trunkPositions) {
            if (level.isEmptyBlock(trunkPos) || level.getBlockState(trunkPos).is(BlockTags.REPLACEABLE_BY_TREES)) continue;
            return false;
        }
        for (BlockPos leavesPos : leavesPositions) {
            if (level.isEmptyBlock(leavesPos) || level.getBlockState(leavesPos).is(BlockTags.REPLACEABLE_BY_TREES)) continue;
            return false;
        }
        for (BlockPos leavesPos : leavesPositions) {
            this.setBlock((LevelWriter)level, leavesPos, ESBlocks.CRADLEWOOD_LEAVES.get().defaultBlockState());
        }
        for (int i4 = 0; i4 < trunkPositions.size(); ++i4) {
            BlockPos trunkPos = (BlockPos)trunkPositions.get(i4);
            Direction.Axis axis = Direction.Axis.Y;
            List<Direction.Axis> availableAxes = Arrays.stream(Direction.Axis.values()).filter(o -> trunkPositions.contains(trunkPos.relative(o, 1)) || trunkPositions.contains(trunkPos.relative(o, -1))).toList();
            if (!availableAxes.isEmpty()) {
                axis = availableAxes.get(random.nextInt(availableAxes.size()));
            }
            this.setBlock((LevelWriter)level, trunkPos, (BlockState)ESBlocks.CRADLEWOOD_LOG.get().defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis));
        }
        return true;
    }

    public record Configuration(IntProvider height, IntProvider horizontalOffset, IntProvider leavesRadius) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IntProvider.CODEC.fieldOf("height").forGetter(Configuration::height), (App)IntProvider.CODEC.fieldOf("horizontal_offset").forGetter(Configuration::horizontalOffset), (App)IntProvider.CODEC.fieldOf("leaves_radius").forGetter(Configuration::leavesRadius)).apply((Applicative)instance, Configuration::new));
    }
}

