/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class UnderwaterSimpleBlockFeature
extends Feature<SimpleBlockConfiguration> {
    public UnderwaterSimpleBlockFeature(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<SimpleBlockConfiguration> featurePlaceContext) {
        SimpleBlockConfiguration simpleBlockConfiguration = (SimpleBlockConfiguration)featurePlaceContext.config();
        WorldGenLevel worldGenLevel = featurePlaceContext.level();
        BlockPos blockPos = featurePlaceContext.origin();
        BlockState blockState = simpleBlockConfiguration.toPlace().getState(featurePlaceContext.random(), blockPos);
        if (blockState.canSurvive((LevelReader)worldGenLevel, blockPos)) {
            if (blockState.getBlock() instanceof DoublePlantBlock) {
                if (!worldGenLevel.isEmptyBlock(blockPos.above()) && !worldGenLevel.getBlockState(blockPos.above()).is(Blocks.WATER)) {
                    return false;
                }
                DoublePlantBlock.placeAt((LevelAccessor)worldGenLevel, (BlockState)blockState, (BlockPos)blockPos, (int)2);
            } else {
                if (worldGenLevel.getFluidState(blockPos).is(FluidTags.WATER) && blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                worldGenLevel.setBlock(blockPos, blockState, 2);
            }
            return true;
        }
        return false;
    }
}

