/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world;

import cn.leolezury.eternalstarlight.common.block.ESPortalBlock;
import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ESTeleporter {
    protected static Optional<BlockPos> getOrMakePortal(ServerLevel level, Entity entity, BlockPos entrancePos, BlockPos pos) {
        Optional<BlockPos> existingPortal = ESTeleporter.getExistingPortal(level, pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        Direction.Axis portalAxis = entity.level().getBlockState(entrancePos).getOptionalValue(ESPortalBlock.AXIS).orElse(Direction.Axis.X);
        return ESTeleporter.makePortal(level, pos, portalAxis);
    }

    public static Optional<BlockPos> getExistingPortal(ServerLevel level, BlockPos pos) {
        int maxHeight = level.getMaxBuildHeight();
        int minHeight = level.getMinBuildHeight();
        WorldBorder border = level.getWorldBorder();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = pos.getX() - 16; x <= pos.getX() + 16; ++x) {
            for (int z = pos.getZ() - 16; z <= pos.getZ() + 16; ++z) {
                for (int y = minHeight; y <= maxHeight; ++y) {
                    blockPos.set(x, y, z);
                    if (!border.isWithinBounds((BlockPos)blockPos) || !level.getBlockState((BlockPos)blockPos).is((Block)ESBlocks.STARLIGHT_PORTAL.get())) continue;
                    return Optional.of(blockPos);
                }
            }
        }
        return Optional.empty();
    }

    public static Optional<BlockPos> makePortal(ServerLevel level, BlockPos blockPos, Direction.Axis axis) {
        int maxHeight = level.getMaxBuildHeight();
        int minHeight = level.getMinBuildHeight();
        WorldBorder border = level.getWorldBorder();
        for (BlockPos.MutableBlockPos pos : BlockPos.spiralAround((BlockPos)blockPos, (int)32, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int height;
            int to;
            int worldSurface = level.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ());
            int from = Math.max(minHeight, worldSurface - 10);
            if (from < (to = Math.min(maxHeight, worldSurface + 10))) {
                for (height = from; height < to; ++height) {
                    pos.setY(height);
                    if (!border.isWithinBounds((BlockPos)pos) || !ESPortalBlock.placePortal((LevelAccessor)level, (BlockPos)pos, axis, 2)) continue;
                    return Optional.of(pos.relative(Direction.UP));
                }
            }
            pos.setY(blockPos.getY());
            for (height = blockPos.getY(); height < maxHeight; ++height) {
                pos.setY(height);
                if (!border.isWithinBounds((BlockPos)pos) || !ESPortalBlock.placePortal((LevelAccessor)level, (BlockPos)pos, axis, 2)) continue;
                return Optional.of(pos.relative(Direction.UP));
            }
            pos.setY(blockPos.getY());
            for (height = blockPos.getY(); height > minHeight; --height) {
                pos.setY(height);
                if (!border.isWithinBounds((BlockPos)pos) || !ESPortalBlock.placePortal((LevelAccessor)level, (BlockPos)pos, axis, 2)) continue;
                return Optional.of(pos.relative(Direction.UP));
            }
        }
        return Optional.empty();
    }

    @Nullable
    public static DimensionTransition getPortalInfo(Entity entity, BlockPos entrancePos, ServerLevel dest) {
        if (entity.level().dimension() != ESDimensions.STARLIGHT_KEY && dest.dimension() != ESDimensions.STARLIGHT_KEY) {
            return null;
        }
        WorldBorder border = dest.getWorldBorder();
        double coordinateDifference = DimensionType.getTeleportationScale((DimensionType)entity.level().dimensionType(), (DimensionType)dest.dimensionType());
        BlockPos pos = border.clampToBounds(entity.getX() * coordinateDifference, entity.getY(), entity.getZ() * coordinateDifference);
        return ESTeleporter.getOrMakePortal(dest, entity, entrancePos, pos).map(result -> new DimensionTransition(dest, Vec3.atCenterOf((Vec3i)result), Vec3.ZERO, entity.getYRot(), entity.getXRot(), DimensionTransition.PLACE_PORTAL_TICKET)).orElse(null);
    }
}

