/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.platform;

import cn.leolezury.eternalstarlight.common.network.SyncAttachmentsPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface EntityDataAttachment<T> {
    public ResourceLocation id();

    public boolean hasData(Entity var1);

    public T getData(Entity var1);

    public Optional<T> getExistingData(Entity var1);

    @Nullable
    public T setDataUnsynced(Entity var1, T var2);

    @Nullable
    default public T setData(Entity entity, T data) {
        Level level;
        T previousValue = this.setDataUnsynced(entity, data);
        if (this.streamCodec() != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.shouldSync(previousValue, data)) {
                ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, entity, SyncAttachmentsPacket.create(entity, this, data, serverLevel.registryAccess()));
            }
        }
        return previousValue;
    }

    @Nullable
    public T removeDataUnsynced(Entity var1);

    @Nullable
    default public T removeData(Entity entity) {
        Level level;
        T previousValue = this.removeDataUnsynced(entity);
        if (this.streamCodec() != null && (level = entity.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.shouldSync(previousValue, null)) {
                ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, entity, SyncAttachmentsPacket.create(entity, this, null, serverLevel.registryAccess()));
            }
        }
        return previousValue;
    }

    @Nullable
    public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec();

    public boolean shouldSync(T var1, T var2);
}

