/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.network;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.platform.EntityDataAttachment;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record SyncAttachmentsPacket(int id, EntityDataAttachment<?> attachment, byte[] data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncAttachmentsPacket> TYPE = new CustomPacketPayload.Type(EternalStarlight.id("sync_attachments"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncAttachmentsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncAttachmentsPacket::id, (StreamCodec)ResourceLocation.STREAM_CODEC.map(id -> Objects.requireNonNull(ESDataAttachments.byId(id)), EntityDataAttachment::id), SyncAttachmentsPacket::attachment, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, SyncAttachmentsPacket::data, SyncAttachmentsPacket::new);

    public static SyncAttachmentsPacket create(Entity entity, EntityDataAttachment<?> attachment, @Nullable Object value, RegistryAccess access) {
        StreamCodec<RegistryFriendlyByteBuf, ?> codec = attachment.streamCodec();
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer(), access);
        if (value != null) {
            buf.writeBoolean(true);
            codec.encode((Object)buf, value);
        } else {
            buf.writeBoolean(false);
        }
        byte[] encoded = buf.array();
        return new SyncAttachmentsPacket(entity.getId(), attachment, encoded);
    }

    public static void handle(SyncAttachmentsPacket packet, Player player) {
        SyncAttachmentsPacket.applyData(packet, player.level());
    }

    @Nullable
    private static Object decodeValue(SyncAttachmentsPacket packet, RegistryAccess access) {
        StreamCodec<RegistryFriendlyByteBuf, ?> codec = packet.attachment().streamCodec();
        if (codec == null) {
            return null;
        }
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.copiedBuffer((byte[])packet.data()), access);
        return !buf.readBoolean() ? null : codec.decode((Object)buf);
    }

    private static void applyData(SyncAttachmentsPacket packet, Level level) {
        Entity entity = level.getEntity(packet.id());
        if (entity != null) {
            Object value = SyncAttachmentsPacket.decodeValue(packet, level.registryAccess());
            if (value == null) {
                packet.attachment().removeData(entity);
            } else {
                packet.attachment().setData(entity, value);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

