/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.network;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record CloseGatekeeperGuiPacket(int id, int operation) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CloseGatekeeperGuiPacket> TYPE = new CustomPacketPayload.Type(EternalStarlight.id("close_gatekeeper_gui"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CloseGatekeeperGuiPacket> STREAM_CODEC = StreamCodec.ofMember(CloseGatekeeperGuiPacket::write, CloseGatekeeperGuiPacket::read);

    public static CloseGatekeeperGuiPacket read(FriendlyByteBuf buf) {
        int id = buf.readInt();
        int operation = buf.readInt();
        return new CloseGatekeeperGuiPacket(id, operation);
    }

    public static void write(CloseGatekeeperGuiPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.id());
        buf.writeInt(packet.operation());
    }

    public static void handle(CloseGatekeeperGuiPacket packet, Player player) {
        ServerPlayer serverPlayer;
        Entity entity;
        if (player instanceof ServerPlayer && (entity = (serverPlayer = (ServerPlayer)player).serverLevel().getEntity(packet.id())) instanceof TheGatekeeper) {
            TheGatekeeper gatekeeper = (TheGatekeeper)entity;
            gatekeeper.handleDialogueClose(packet.operation());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

