/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Nullable
    PostChain postEffect;

    @Shadow
    protected abstract void loadEffect(ResourceLocation var1);

    @Inject(method={"checkEntityPostEffect(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    private void checkEntityPostEffect(Entity entity, CallbackInfo ci) {
        if (this.postEffect == null) {
            if (entity instanceof SoulitSpectator) {
                this.loadEffect(EternalStarlight.id("shaders/post/soulit_spectator.json"));
            } else if (ClientHandlers.tearyEffect) {
                this.loadEffect(ResourceLocation.withDefaultNamespace((String)"shaders/post/blur.json"));
            }
        }
    }
}

