/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.misc;

import cn.leolezury.eternalstarlight.common.entity.misc.EyeOfSeeking;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.Structure;

public class SeekingEyeItem
extends Item {
    public SeekingEyeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        if (level instanceof ServerLevel) {
            BlockPos blockPos;
            ServerLevel serverLevel = (ServerLevel)level;
            TagKey<Structure> key = ESTags.Structures.BOSS_STRUCTURES;
            if (player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).is(ESTags.Items.GOLEM_FORGE_LOCATORS)) {
                key = ESTags.Structures.GOLEM_FORGE;
            }
            if (player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND).is(ESTags.Items.CURSED_GARDEN_LOCATORS)) {
                key = ESTags.Structures.CURSED_GARDEN;
            }
            if ((blockPos = serverLevel.findNearestMapStructure(key, player.blockPosition(), 100, false)) != null) {
                EyeOfSeeking eyeOfSeeking = new EyeOfSeeking(level, player.getX(), player.getY(0.5), player.getZ());
                eyeOfSeeking.setItem(itemStack);
                eyeOfSeeking.signalTo(blockPos);
                level.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT, eyeOfSeeking.position(), GameEvent.Context.of((Entity)player));
                level.addFreshEntity((Entity)eyeOfSeeking);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), ESSoundEvents.SEEKING_EYE_LAUNCH.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                itemStack.consume(1, (LivingEntity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                player.swing(hand, true);
                return InteractionResultHolder.success((Object)itemStack);
            }
        }
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, components, tooltipFlag);
        components.add((Component)Component.translatable((String)"tooltip.eternal_starlight.seeking_eye").withColor(7062225));
    }
}

