/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownBoomerang;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class BoomerangItem
extends TieredItem
implements ProjectileItem {
    public BoomerangItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public abstract ThrownBoomerang createBoomerang(Level var1, @Nullable LivingEntity var2, double var3, double var5, double var7, ItemStack var9);

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (BoomerangItem.isTooDamagedToUse(stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            Vec3 shootPos = player.getEyePosition();
            ThrownBoomerang boomerang = this.createBoomerang(level, (LivingEntity)player, shootPos.x, shootPos.y, shootPos.z, stack);
            boomerang.setNoGravity(true);
            boomerang.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.3f);
            if (player.hasInfiniteMaterials()) {
                boomerang.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.addFreshEntity((Entity)boomerang);
            if (!player.hasInfiniteMaterials()) {
                player.getInventory().removeItem(stack);
            }
            player.getCooldowns().addCooldown((Item)this, 15);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.consume((Object)stack);
    }

    private static boolean isTooDamagedToUse(ItemStack stack) {
        return stack.getDamageValue() >= stack.getMaxDamage() - 1;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public int getEnchantmentValue() {
        return 1;
    }
}

