/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class WiltedPetal
extends ThrowableProjectile {
    public float oSpin;
    public float spin;

    public WiltedPetal(EntityType<? extends WiltedPetal> entityType, Level level) {
        super(entityType, level);
    }

    public WiltedPetal(Level level, LivingEntity livingEntity) {
        super(ESEntities.WILTED_PETAL.get(), livingEntity, level);
    }

    public WiltedPetal(Level level, double x, double y, double z) {
        super(ESEntities.WILTED_PETAL.get(), x, y, z, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 80) {
            this.discard();
        }
        this.oSpin = this.spin;
        this.spin += 0.18849556f;
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        switch (hitResult.getDirection().getAxis()) {
            case X: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(-0.5, 1.0, 1.0));
                break;
            }
            case Y: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.5, 1.0));
                break;
            }
            case Z: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 1.0, -0.5));
            }
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        if (hitResult.getEntity() != this.getOwner()) {
            hitResult.getEntity().hurt(ESDamageTypes.getIndirectEntityDamageSource(this.level(), ESDamageTypes.WILT, (Entity)this, this.getOwner()), 8.0f);
        }
        this.discard();
    }
}

