/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.projectile;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESDamageTypes;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Creteor;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ESExplosionParticleOptions;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class AethersentMeteor
extends AbstractHurtingProjectile
implements TrailOwner {
    private static final ResourceLocation TRAIL_TEXTURE = EternalStarlight.id("textures/entity/trail.png");
    private static final String TAG_SIZE = "size";
    private static final String TAG_TARGET = "target";
    private static final String TAG_TARGET_X = "target_x";
    private static final String TAG_TARGET_Y = "target_y";
    private static final String TAG_TARGET_Z = "target_z";
    private static final String TAG_NATURAL = "natural";
    protected static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.defineId(AethersentMeteor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private LivingEntity target;
    @Nullable
    private UUID targetId;
    private Vec3 targetPos = Vec3.ZERO;
    private boolean natural = true;

    public int getSize() {
        return (Integer)this.getEntityData().get(SIZE);
    }

    public void setSize(int size) {
        this.getEntityData().set(SIZE, (Object)size);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.targetId = target.getUUID();
        }
    }

    public void setTargetPos(Vec3 targetPos) {
        this.targetPos = targetPos;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public AethersentMeteor(EntityType<? extends AethersentMeteor> type, Level level) {
        super(type, level);
    }

    public AethersentMeteor(Level level, LivingEntity entity, double x, double y, double z) {
        this(ESEntities.AETHERSENT_METEOR.get(), level);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setPos(x, y, z);
        this.setOwner((Entity)entity);
    }

    public static void createMeteorShower(Level level, LivingEntity entity, LivingEntity target, double targetX, double targetY, double targetZ, double height) {
        if (!level.isClientSide) {
            if (ESDataAttachments.METEOR_COOLDOWN.getData((Entity)entity) > 0) {
                return;
            }
            ESDataAttachments.METEOR_COOLDOWN.setData((Entity)entity, 20);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    RandomSource random = entity.getRandom();
                    AethersentMeteor meteor = new AethersentMeteor(level, entity, targetX + (double)x + ((double)random.nextFloat() - 0.5) * 3.0, targetY + height + ((double)random.nextFloat() - 0.5) * 5.0, targetZ + (double)z + ((double)random.nextFloat() - 0.5) * 3.0);
                    meteor.setSize(random.nextInt(2, 5));
                    meteor.setTarget(target);
                    meteor.setTargetPos(new Vec3(targetX, targetY, targetZ));
                    meteor.natural = false;
                    level.addFreshEntity((Entity)meteor);
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ESExplosionParticleOptions.AETHERSENT, meteor.getX(), meteor.getY(), meteor.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIZE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setSize(compoundTag.getInt(TAG_SIZE));
        if (compoundTag.hasUUID(TAG_TARGET)) {
            this.targetId = compoundTag.getUUID(TAG_TARGET);
        }
        this.targetPos = new Vec3(compoundTag.getDouble(TAG_TARGET_X), compoundTag.getDouble(TAG_TARGET_Y), compoundTag.getDouble(TAG_TARGET_Z));
        if (compoundTag.contains(TAG_NATURAL, 1)) {
            this.natural = compoundTag.getBoolean(TAG_NATURAL);
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt(TAG_SIZE, this.getSize());
        if (this.target != null) {
            compoundTag.putUUID(TAG_TARGET, this.target.getUUID());
        }
        if (this.targetPos != null) {
            compoundTag.putDouble(TAG_TARGET_X, this.targetPos.x);
            compoundTag.putDouble(TAG_TARGET_Y, this.targetPos.y);
            compoundTag.putDouble(TAG_TARGET_Z, this.targetPos.z);
        }
        compoundTag.putBoolean(TAG_NATURAL, this.natural);
    }

    public void dropAndDiscard(boolean clean) {
        if (!this.isRemoved() && !this.level().isClientSide) {
            if (this.natural && this.getSize() >= 10) {
                ItemEntity entity = this.spawnAtLocation(new ItemStack((ItemLike)ESItems.RAW_AETHERSENT.get(), this.random.nextInt(20, 30)));
                if (entity != null) {
                    entity.setGlowingTag(true);
                }
                if (!clean) {
                    if (ESConfig.INSTANCE.aethersentMeteorReplaceBlocks) {
                        for (int x = -3; x <= 3; ++x) {
                            for (int y = -3; y <= 3; ++y) {
                                for (int z = -3; z <= 3; ++z) {
                                    BlockPos pos = this.blockPosition().offset(x, y, z);
                                    boolean canDestroy = ESPlatform.INSTANCE.postEntityDestroyBlockEvent(this.level(), pos, (Entity)this);
                                    if (!canDestroy || !(pos.distToCenterSqr((Position)this.blockPosition().getCenter()) <= 3.5) || !this.level().getBlockState(pos).is(ESTags.Blocks.AETHERSENT_METEOR_REPLACEABLES)) continue;
                                    this.level().setBlockAndUpdate(pos, this.random.nextBoolean() ? ESBlocks.RAW_AETHERSENT_BLOCK.get().defaultBlockState() : ESBlocks.NEBULAITE.get().defaultBlockState());
                                }
                            }
                        }
                    }
                    if (ESConfig.INSTANCE.mobsConfig.creteor.canSpawn() && (double)this.random.nextFloat() < ESConfig.INSTANCE.mobsConfig.creteor.spawnChance() && this.level().getEntitiesOfClass(Creteor.class, this.getBoundingBox().inflate(32.0)).isEmpty()) {
                        Creteor creteor = new Creteor(ESEntities.CRETEOR.get(), this.level());
                        creteor.setPos(this.position());
                        creteor.setPersistenceRequired();
                        this.level().addFreshEntity((Entity)creteor);
                    }
                    for (int m = 0; m < ((ServerLevel)this.level()).players().size(); ++m) {
                        ServerPlayer serverPlayer = (ServerPlayer)((ServerLevel)this.level()).players().get(m);
                        ((ServerLevel)this.level()).sendParticles(serverPlayer, (ParticleOptions)ESParticles.AETHERSENT_EXPLOSION.get(), true, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    Level m = this.level();
                    if (m instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)m;
                        for (int i = 0; i < 25; ++i) {
                            Vec3 speed = new Vec3((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)).normalize();
                            ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.position().x + speed.x * 1.2, this.position().y + speed.y * 1.2, this.position().z + speed.z * 1.2, speed.x, speed.y, speed.z));
                        }
                    }
                }
            }
            this.discard();
        }
    }

    protected void onHit(HitResult hitResult) {
        Object serverLevel;
        super.onHit(hitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            ScreenShakeVfx.createInstance((ResourceKey<Level>)this.level().dimension(), this.position(), 45.0f, 40, 0.01f, 0.015f, 4.5f, 5.0f).send((ServerLevel)serverLevel);
        }
        for (LivingEntity livingEntity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)this.getSize(), 0.0, (double)this.getSize()))) {
            if (!ESEntityUtil.shouldHarm(this.getOwner(), (Entity)livingEntity)) continue;
            livingEntity.invulnerableTime = 0;
            livingEntity.hurt(ESDamageTypes.getEntityDamageSource(this.level(), ESDamageTypes.METEOR, this.getOwner()), (float)this.getSize() * 5.0f * (this.getOwner() instanceof LivingEntity ? 0.08f : 1.0f));
        }
        if (this.getTarget() != null && this.getY() < this.getTarget().getY() || this.getY() < this.targetPos.y) {
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundVolume(), this.getVoicePitch());
            if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)(this.getSize() >= 8 ? ParticleTypes.EXPLOSION_EMITTER : ESExplosionParticleOptions.AETHERSENT), this.getX(), this.getY() + 0.05 * (double)this.getSize(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                this.discard();
            }
        }
        if (this.natural) {
            this.dropAndDiscard(false);
        }
    }

    public void tick() {
        Level level;
        super.tick();
        this.setDeltaMovement(0.0, this.natural ? -2.0 : -4.0, 0.0);
        if (this.tickCount % 10 == 0) {
            this.refreshDimensions();
        }
        if (!this.level().isClientSide && this.target == null && this.targetId != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(this.targetId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.target = livingEntity = (LivingEntity)entity;
            }
            if (this.target == null) {
                this.targetId = null;
            }
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return super.getDimensions(pose).scale((float)this.getSize() / 10.0f);
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public TrailEffect newTrail() {
        return new TrailEffect(Math.max((float)this.getSize() / 10.0f, 0.4f), 15);
    }

    @Override
    public void updateTrail(TrailEffect effect) {
        Vec3 oldPos = new Vec3(this.xOld, this.yOld, this.zOld);
        effect.update(oldPos.add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0));
        if (this.isRemoved()) {
            effect.setLength(Math.max(effect.getLength() - 1.2f, 0.0f));
        }
    }

    @Override
    public Vector4f getTrailColor() {
        return new Vector4f(0.5647059f, 0.36862746f, 0.65882355f, 1.0f);
    }

    @Override
    public boolean isTrailFullBright() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public RenderType getTrailRenderType() {
        return ESRenderType.entityTranslucentGlow(TRAIL_TEXTURE);
    }
}

