/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.phase;

import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.living.phase.MultiBehaviorUser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;

public class MeleeAttackPhase<T extends LivingEntity>
extends BehaviorPhase<T> {
    private final List<Entry> entries = new ArrayList<Entry>();

    public MeleeAttackPhase(int id, int priority, int duration, int cooldown) {
        super(id, priority, duration, cooldown);
    }

    @Override
    public boolean canStart(T entity, boolean cooldownOver) {
        return cooldownOver && !this.entries.isEmpty() && this.canReachTarget(entity, this.entries.getFirst().range());
    }

    @Override
    public void onStart(T entity) {
    }

    @Override
    public void tick(T entity) {
        for (Entry entry : this.entries) {
            if (((MultiBehaviorUser)entity).getBehaviorTicks() != entry.tick()) continue;
            this.performMeleeAttack(entity, entry.range());
        }
    }

    @Override
    public boolean canContinue(T entity) {
        return true;
    }

    @Override
    public void onStop(T entity) {
    }

    public MeleeAttackPhase<T> with(int range, int tick) {
        this.entries.add(new Entry(range, tick));
        this.entries.sort(Comparator.comparingInt(Entry::range));
        return this;
    }

    private record Entry(int range, int tick) {
    }
}

