/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity;

import cn.leolezury.eternalstarlight.common.entity.living.boss.monstrosity.LunarMonstrosity;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.util.ESBlockUtil;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class LunarMonstrositySneakPhase
extends BehaviorPhase<LunarMonstrosity> {
    public static final int ID = 6;

    public LunarMonstrositySneakPhase() {
        super(6, 1, 200, 0, 7);
    }

    @Override
    public boolean canStart(LunarMonstrosity entity, boolean cooldownOver) {
        return false;
    }

    @Override
    public void onStart(LunarMonstrosity entity) {
    }

    @Override
    public void tick(LunarMonstrosity entity) {
        Vec3 fleePos;
        entity.clearFire();
        if ((entity.isInLava() || ESBlockUtil.getBlocksInBoundingBox(entity.getNormalStateBoundingBox().inflate(1.0)).stream().anyMatch(pos -> entity.level().getFluidState(pos).is(FluidTags.LAVA))) && entity.tickCount % 20 == 0 && (fleePos = LandRandomPos.getPosAway((PathfinderMob)entity, (int)20, (int)8, (Vec3)entity.position())) != null) {
            entity.randomTeleport(fleePos.x, fleePos.y, fleePos.z, false);
        }
    }

    @Override
    public boolean canContinue(LunarMonstrosity entity) {
        return true;
    }

    @Override
    public void onStop(LunarMonstrosity entity) {
    }
}

