/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESBiomes;
import cn.leolezury.eternalstarlight.common.data.ESDataTransformers;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.world.gen.biomesource.ESBiomeSource;
import cn.leolezury.eternalstarlight.common.world.gen.chunkgenerator.ESChunkGenerator;
import cn.leolezury.eternalstarlight.common.world.gen.surface.OnSurfaceCondition;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class ESDimensions {
    public static final ResourceKey<Level> STARLIGHT_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)EternalStarlight.id("starlight"));
    public static final ResourceKey<LevelStem> STARLIGHT_LEVEL_STEM = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)EternalStarlight.id("starlight"));
    public static final ResourceKey<DimensionType> STARLIGHT_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)EternalStarlight.id("starlight"));
    public static final ResourceKey<NoiseGeneratorSettings> STARLIGHT_NOISE_SETTINGS = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)EternalStarlight.id("starlight"));
    public static final int SEA_LEVEL = 50;

    private static SurfaceRules.RuleSource makeAbyss() {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)-25), (int)1)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.CRYOBYSSLATE.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)-10), (int)1)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.ABYSSLATE.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)50), (int)1)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.THERMABYSSLATE.get().defaultBlockState()))});
    }

    private static SurfaceRules.RuleSource makeSurfaceRule() {
        SurfaceRules.RuleSource surface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.CRYSTALLIZED_DESERT, ESBiomes.SHIMMER_RIVER, ESBiomes.ETHER_RIVER, ESBiomes.WARM_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.TWILIGHT_SAND.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.STARLIT_SEA, ESBiomes.SPIRAL_KELP_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.DUSTED_GRAVEL.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.DARK_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)0, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.FANTASY_GRASS_BLOCK.get().defaultBlockState())), SurfaceRules.state((BlockState)ESBlocks.NIGHTFALL_MUD.get().defaultBlockState())})), SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)0, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.NIGHTFALL_GRASS_BLOCK.get().defaultBlockState())), SurfaceRules.state((BlockState)ESBlocks.NIGHTFALL_DIRT.get().defaultBlockState())})})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.LUSH_SHALLOW_SEA}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition((ResourceKey)Noises.ICE, (double)-0.0625, (double)0.025), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.GLOWING_MOSSY_DUSTED_GRAVEL.get().defaultBlockState())), SurfaceRules.state((BlockState)ESBlocks.MOSSY_DUSTED_GRAVEL.get().defaultBlockState())}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.CRYSTALLIZED_DESERT, ESBiomes.SHIMMER_RIVER, ESBiomes.ETHER_RIVER, ESBiomes.WARM_SHORE}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.TWILIGHT_SAND.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.STARLIT_SEA, ESBiomes.SPIRAL_KELP_FOREST, ESBiomes.LUSH_SHALLOW_SEA}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.DUSTED_GRAVEL.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.DARK_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.NIGHTFALL_MUD.get().defaultBlockState())), SurfaceRules.state((BlockState)ESBlocks.NIGHTFALL_DIRT.get().defaultBlockState())})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.VERY_DEEP_UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.CRYSTALLIZED_DESERT}), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.TWILIGHT_SANDSTONE.get().defaultBlockState())))});
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)Blocks.BEDROCK.defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.THE_ABYSS}), (SurfaceRules.RuleSource)ESDimensions.makeAbyss()), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)OnSurfaceCondition.INSTANCE, (SurfaceRules.RuleSource)surface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.STARLIGHT_PERMAFROST_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"stone", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.HAZE_ICE.get().defaultBlockState())), SurfaceRules.state((BlockState)ESBlocks.ETERNAL_ICE.get().defaultBlockState())})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ESBiomes.DARK_SWAMP}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"stone", (VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)40))), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.NIGHTFALL_MUD.get().defaultBlockState())), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"stone", (VerticalAnchor)VerticalAnchor.absolute((int)22), (VerticalAnchor)VerticalAnchor.absolute((int)30))), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.PACKED_NIGHTFALL_MUD.get().defaultBlockState()))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"stone", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8)), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)ESBlocks.VOIDSTONE.get().defaultBlockState()))});
    }

    public static void bootstrapNoiseSettings(BootstrapContext<NoiseGeneratorSettings> context) {
        NoiseGeneratorSettings settings = new NoiseGeneratorSettings(NoiseSettings.create((int)-64, (int)384, (int)1, (int)4), ESBlocks.GRIMSTONE.get().defaultBlockState(), Blocks.WATER.defaultBlockState(), new NoiseRouter(DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero()), ESDimensions.makeSurfaceRule(), List.of(), 50, false, false, false, false);
        context.register(STARLIGHT_NOISE_SETTINGS, (Object)settings);
    }

    public static void bootstrapLevelStem(BootstrapContext<LevelStem> context) {
        int i;
        HolderGetter biomeHolderGetter = context.lookup(Registries.BIOME);
        HolderGetter dimensionTypeHolderGetter = context.lookup(Registries.DIMENSION_TYPE);
        HolderGetter noiseSettingsHolderGetter = context.lookup(Registries.NOISE_SETTINGS);
        HolderGetter transformers = context.lookup(ESRegistries.DATA_TRANSFORMER);
        ArrayList<WorldGenProvider.TransformerWithSeed> biomeTransformers = new ArrayList<WorldGenProvider.TransformerWithSeed>();
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ADD_OCEAN), 0));
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.APPLY_BIOMES), 0));
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.DUPLICATE), 0));
        for (i = 0; i < 6; ++i) {
            biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.DUPLICATE), i));
            biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.RANDOMIZE_BIOMES), i));
            biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ASSIMILATE_BIOMES), i));
            biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ASSIMILATE_LONELY_BIOMES), i));
        }
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ASSIMILATE_LONELY_BIOMES), 0));
        for (i = 0; i < 4; ++i) {
            biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ADD_BEACHES), 0));
        }
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ADD_RIVERS_AND_ABYSS), 0));
        for (i = 0; i < 3; ++i) {
            biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.ADD_TRANSITIONS), 0));
        }
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.DUPLICATE), 0));
        biomeTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.DUPLICATE), 0));
        ArrayList<WorldGenProvider.TransformerWithSeed> heightTransformers = new ArrayList<WorldGenProvider.TransformerWithSeed>();
        heightTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.SMOOTH_HEIGHTS_LARGE), 0));
        heightTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.NOISE_HEIGHT), 0));
        heightTransformers.add(new WorldGenProvider.TransformerWithSeed((Holder<DataTransformer>)transformers.getOrThrow(ESDataTransformers.SMOOTH_HEIGHTS_SMALL), 0));
        WorldGenProvider provider = new WorldGenProvider(biomeTransformers, heightTransformers, 320, -64);
        LevelStem levelStem = new LevelStem((Holder)dimensionTypeHolderGetter.getOrThrow(STARLIGHT_TYPE), (ChunkGenerator)new ESChunkGenerator(new ESBiomeSource(provider, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biomeHolderGetter.getOrThrow(ESBiomes.STARLIGHT_FOREST), biomeHolderGetter.getOrThrow(ESBiomes.STARLIGHT_DENSE_FOREST), biomeHolderGetter.getOrThrow(ESBiomes.STARLIGHT_PERMAFROST_FOREST), biomeHolderGetter.getOrThrow(ESBiomes.DARK_SWAMP), biomeHolderGetter.getOrThrow(ESBiomes.SCARLET_FOREST), biomeHolderGetter.getOrThrow(ESBiomes.TORREYA_FOREST), biomeHolderGetter.getOrThrow(ESBiomes.CRYSTALLIZED_DESERT), biomeHolderGetter.getOrThrow(ESBiomes.SHIMMER_RIVER), biomeHolderGetter.getOrThrow(ESBiomes.ETHER_RIVER), biomeHolderGetter.getOrThrow(ESBiomes.STARLIT_SEA), biomeHolderGetter.getOrThrow(ESBiomes.SPIRAL_KELP_FOREST), biomeHolderGetter.getOrThrow(ESBiomes.LUSH_SHALLOW_SEA), biomeHolderGetter.getOrThrow(ESBiomes.THE_ABYSS), biomeHolderGetter.getOrThrow(ESBiomes.WARM_SHORE)})), (Holder<NoiseGeneratorSettings>)noiseSettingsHolderGetter.getOrThrow(STARLIGHT_NOISE_SETTINGS)));
        context.register(STARLIGHT_LEVEL_STEM, (Object)levelStem);
    }

    public static void bootstrapDimType(BootstrapContext<DimensionType> context) {
        DimensionType type = new DimensionType(OptionalLong.of(12900L), true, false, false, true, 1.0, true, true, -64, 384, 384, BlockTags.INFINIBURN_OVERWORLD, EternalStarlight.id("special_effect"), 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)7), 7));
        context.register(STARLIGHT_TYPE, (Object)type);
    }
}

