/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.resource;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.book.BookDefinition;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BookLoader
extends SimpleJsonResourceReloadListener {
    private final Map<ResourceLocation, BookDefinition> books = new HashMap<ResourceLocation, BookDefinition>();

    public BookLoader() {
        super(new Gson(), "eternal_starlight/books");
    }

    @Nullable
    public BookDefinition getBook(ResourceLocation key) {
        return this.books.get(key);
    }

    public void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.books.clear();
        int loaded = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            try {
                BookDefinition definition = (BookDefinition)BookDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                this.books.put(entry.getKey(), definition);
                ++loaded;
            }
            catch (Exception e) {
                EternalStarlight.LOGGER.error("Failed to book definition {}", (Object)entry.getKey(), (Object)e);
            }
        }
        EternalStarlight.LOGGER.info("Loaded {} book definitions", (Object)loaded);
    }
}

