/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.entity.projectile.WiltedPetal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WiltedPetalRenderer
extends EntityRenderer<WiltedPetal> {
    private static final ResourceLocation TEXTURE_LOCATION = EternalStarlight.id("textures/entity/wilted_petal.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE_LOCATION);

    public WiltedPetalRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(WiltedPetal entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        poseStack.scale(0.6f, 0.6f, 0.6f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexConsumer = buffer.getBuffer(RENDER_TYPE);
        WiltedPetalRenderer.vertex(vertexConsumer, pose, packedLight, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin)), 0.0f, 1.0f);
        WiltedPetalRenderer.vertex(vertexConsumer, pose, packedLight, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 1.5707964f)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 1.5707964f)), 1.0f, 1.0f);
        WiltedPetalRenderer.vertex(vertexConsumer, pose, packedLight, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + (float)Math.PI)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + (float)Math.PI)), 1.0f, 0.0f);
        WiltedPetalRenderer.vertex(vertexConsumer, pose, packedLight, 0.5f * Mth.SQRT_OF_TWO * Mth.sin((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 4.712389f)), 0.5f * Mth.SQRT_OF_TWO * Mth.cos((float)(Mth.lerp((float)partialTicks, (float)entity.oSpin, (float)entity.spin) + 4.712389f)), 0.0f, 0.0f);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, float y, float u, float v) {
        consumer.addVertex(pose, x, y, 0.0f).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(WiltedPetal entity) {
        return TEXTURE_LOCATION;
    }
}

