/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.entity.misc.TearBomb;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.TntMinecartRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TearBombRenderer
extends EntityRenderer<TearBomb> {
    private final BlockRenderDispatcher blockRenderer;

    public TearBombRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(TearBomb bomb, float yaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        stack.pushPose();
        stack.translate(0.0f, 0.5f, 0.0f);
        int fuse = bomb.getFuse();
        if ((float)fuse - partialTicks + 1.0f < 10.0f) {
            float h = 1.0f - ((float)fuse - partialTicks + 1.0f) / 10.0f;
            h = Mth.clamp((float)h, (float)0.0f, (float)1.0f);
            h *= h;
            h *= h;
            float k = 1.0f + h * 0.3f;
            stack.scale(k, k, k);
        }
        stack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        stack.translate(-0.5f, -0.5f, 0.5f);
        stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        TntMinecartRenderer.renderWhiteSolidBlock((BlockRenderDispatcher)this.blockRenderer, (BlockState)bomb.getBlockState(), (PoseStack)stack, (MultiBufferSource)bufferSource, (int)packedLight, (fuse / 5 % 2 == 0 ? 1 : 0) != 0);
        stack.popPose();
        super.render((Entity)bomb, yaw, partialTicks, stack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(TearBomb tearBomb) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

