/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.entity.attack.CrystalCluster;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class CrystalClusterRenderer
extends EntityRenderer<CrystalCluster> {
    private final BlockRenderDispatcher dispatcher;

    public CrystalClusterRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.2f;
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(CrystalCluster cluster, float yaw, float delta, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        Level level;
        BlockState state;
        BlockState blockState = state = cluster.clientCrystalType == 1 ? ESBlocks.RED_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState() : ESBlocks.BLUE_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState();
        if (state.getRenderShape() == RenderShape.MODEL && state != (level = cluster.level()).getBlockState(cluster.blockPosition()) && state.getRenderShape() != RenderShape.INVISIBLE) {
            stack.pushPose();
            BlockPos pos = BlockPos.containing((double)cluster.getX(), (double)cluster.getBoundingBox().maxY, (double)cluster.getZ());
            float scale = Math.max(Mth.lerp((float)delta, (float)cluster.oldClientScale, (float)cluster.clientScale), 0.0f);
            stack.mulPose(new Quaternionf().rotateY(-yaw * ((float)Math.PI / 180)));
            stack.translate(-0.5 * (double)scale, 0.0, -0.5 * (double)scale);
            stack.scale(scale, scale, scale);
            ESPlatform.INSTANCE.renderBlock(this.dispatcher, stack, bufferSource, level, state, pos, state.getSeed(cluster.blockPosition()));
            stack.popPose();
            super.render((Entity)cluster, yaw, delta, stack, bufferSource, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(CrystalCluster cluster) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

