/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BaseAshSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OrbitalAshenSnowParticle
extends BaseAshSmokeParticle {
    private final double cx;
    private final double cz;
    private final float maxRadius;
    private final float rotSpeed;
    private float radius;
    private float oRadius;
    private float angle;
    private float oAngle;

    protected OrbitalAshenSnowParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, 1.0f, 1.0f, 1.0f, xSpeed, ySpeed, zSpeed, 1.25f, sprites, 1.0f, 20, 0.0125f, true);
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.lifetime *= 4;
        this.cx = x;
        this.cz = z;
        this.oAngle = this.angle = (this.random.nextFloat() * 90.0f + 90.0f) * (float)(this.random.nextBoolean() ? 1 : -1);
        this.maxRadius = this.random.nextFloat() * 3.0f + 2.0f;
        this.rotSpeed = (this.random.nextFloat() * 5.0f + 3.0f) * (float)(this.random.nextBoolean() ? 1 : -1);
    }

    public void tick() {
        super.tick();
        this.oAngle = this.angle;
        this.angle += this.rotSpeed;
        this.oRadius = this.radius;
        this.radius += 0.25f;
        if (this.radius > this.maxRadius) {
            this.radius = this.maxRadius;
        }
        if (!this.onGround) {
            Vec3 pos = ESMathUtil.rotationToPosition(new Vec3(this.cx, 0.0, this.cz), this.radius, 0.0f, this.angle);
            this.setPos(pos.x, this.y, pos.z);
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        if (!this.onGround) {
            Vec3 pos = ESMathUtil.rotationToPosition(new Vec3(this.cx, 0.0, this.cz), Mth.lerp((float)partialTick, (float)this.oRadius, (float)this.radius), 0.0f, Mth.lerp((float)partialTick, (float)this.oAngle, (float)this.angle));
            this.x = pos.x;
            this.z = pos.z;
        }
        super.render(consumer, camera, partialTick);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xs, double ys, double zs) {
            return new OrbitalAshenSnowParticle(level, x, y, z, xs, ys, zs, this.sprites);
        }
    }
}

