/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class LunarSlashParticle
extends TextureSheetParticle {
    private static final int DIVISION = 72;
    private static final float CELL = 2.5f;
    private final float yRot;
    private final float zRot;

    protected LunarSlashParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, SpriteSet spriteSet) {
        super(clientLevel, x, y, z);
        this.stoppedByCollision = true;
        this.lifetime = (int)(this.random.nextFloat() * 5.0f + 10.0f);
        this.yRot = ESMathUtil.positionToYaw(new Vec3(dx, dy, dz)) * ((float)Math.PI / 180);
        this.zRot = (float)Math.PI * 2 * this.random.nextFloat();
        this.pickSprite(spriteSet);
    }

    public void move(double d, double e, double f) {
        super.move(d, e, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        float progress = Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime;
        double currentX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x);
        double currentY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y);
        double currentZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z);
        Vec3 camPos = camera.getPosition();
        PoseStack stack = new PoseStack();
        stack.pushPose();
        stack.translate(currentX - camPos.x, currentY - camPos.y, currentZ - camPos.z);
        stack.mulPose(new Quaternionf().rotationX(1.5707964f));
        stack.mulPose(new Quaternionf().rotationZ(this.yRot));
        stack.mulPose(new Quaternionf().rotationX(this.zRot));
        VertexConsumer vertexConsumer = ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.GLOW_PARTICLE);
        float lastYawOffset = 0.0f;
        Vec3 lastInnerPos = Vec3.ZERO;
        Vec3 lastOuterPos = Vec3.ZERO;
        for (int i = 0; i < 36; ++i) {
            float yawOffset = progress * 270.0f - (float)i * 2.5f;
            Vec3 innerPos = ESMathUtil.rotationToPosition(1.0f, 0.0f, -90.0f + yawOffset);
            Vec3 outerPos = ESMathUtil.rotationToPosition(1.0f + Mth.sin((float)(yawOffset / 180.0f * (float)Math.PI)) * 1.25f, 0.0f, -90.0f + yawOffset);
            if (i != 0 && lastYawOffset > 0.0f && yawOffset < 180.0f) {
                Vec3 renderLastInnerPos = lastInnerPos;
                Vec3 renderLastOuterPos = lastOuterPos;
                Vec3 renderInnerPos = innerPos;
                Vec3 renderOuterPos = outerPos;
                if (yawOffset < 0.0f) {
                    renderOuterPos = renderInnerPos = ESMathUtil.rotationToPosition(1.0f, 0.0f, -90.0f);
                }
                if (lastYawOffset > 180.0f) {
                    renderLastOuterPos = renderLastInnerPos = ESMathUtil.rotationToPosition(1.0f, 0.0f, 90.0f);
                }
                PoseStack.Pose pose = stack.last();
                float u0 = this.getU0();
                float u1 = this.getU1();
                float v0 = this.getV0();
                float v1 = this.getV1();
                vertexConsumer.addVertex(pose, renderLastInnerPos.toVector3f()).setColor(0.5019608f, 0.6117647f, 0.9411765f, 1.0f - (float)(i - 1) / 36.0f).setUv(u0, v0).setLight(0xF000F0);
                vertexConsumer.addVertex(pose, renderLastOuterPos.toVector3f()).setColor(0.5019608f, 0.6117647f, 0.9411765f, 1.0f - (float)(i - 1) / 36.0f).setUv(u0, v1).setLight(0xF000F0);
                vertexConsumer.addVertex(pose, renderOuterPos.toVector3f()).setColor(0.5019608f, 0.6117647f, 0.9411765f, 1.0f - (float)i / 36.0f).setUv(u1, v1).setLight(0xF000F0);
                vertexConsumer.addVertex(pose, renderInnerPos.toVector3f()).setColor(0.5019608f, 0.6117647f, 0.9411765f, 1.0f - (float)i / 36.0f).setUv(u1, v0).setLight(0xF000F0);
            }
            lastYawOffset = yawOffset;
            lastInnerPos = innerPos;
            lastOuterPos = outerPos;
        }
        stack.popPose();
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new LunarSlashParticle(level, x, y, z, dx, dy, dz, this.sprites);
        }
    }
}

