/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.LuminarisAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.animal.Luminaris;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LuminarisModel<T extends Luminaris>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("luminaris"), "main");
    private final ModelPart head;

    public LuminarisModel(ModelPart root) {
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -3.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(13, 0).addBox(-3.0f, -2.9f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(13, 0).addBox(1.0f, -2.9f, -2.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(6, 10).addBox(-1.5f, -1.0f, -2.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(6, 10).addBox(1.5f, -1.0f, -2.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        head.addOrReplaceChild("horn", CubeListBuilder.create().texOffs(10, 8).addBox(-1.5f, -0.2929f, -4.7071f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.0f, (float)-1.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("lower_jaw", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition body = head.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)2.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.0f, 0.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        head.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(10, 13).addBox(0.0f, 0.5f, 0.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)-2.0f, (float)1.0f));
        head.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(10, 13).addBox(-2.0f, 0.5f, 0.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-2.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((Luminaris)entity).swimAnimationState, LuminarisAnimation.SWIM, ageInTicks, 1.0f, entity.isInWater() ? 1.0f : 1.5f);
        if (((Luminaris)entity).isCharging()) {
            this.animate(((Luminaris)entity).chargeAnimationState, LuminarisAnimation.CHARGE, ageInTicks);
        }
    }

    @Override
    public ModelPart root() {
        return this.head;
    }
}

