/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.toast;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleTextToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    public static final int DISPLAY_TIME = 5000;
    private final Component title;
    private final Component text;
    private final ItemStack icon;
    private boolean playedSound;

    public SimpleTextToast(Component title, Component text, ItemStack icon) {
        this.title = title;
        this.text = text;
        this.icon = icon;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        List list = toastComponent.getMinecraft().font.split((FormattedText)this.text, 125);
        if (list.size() == 1) {
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 7, -1, false);
            guiGraphics.drawString(toastComponent.getMinecraft().font, (FormattedCharSequence)list.getFirst(), 30, 18, -1, false);
        } else if (timeSinceLastVisible < 1500L) {
            int color = Mth.floor((float)(Mth.clamp((float)((float)(1500L - timeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 11, 0xFFFF00 | color, false);
        } else {
            int color = Mth.floor((float)(Mth.clamp((float)((float)(timeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
            int textY = this.height() / 2 - list.size() * 9 / 2;
            for (FormattedCharSequence formattedcharsequence : list) {
                guiGraphics.drawString(toastComponent.getMinecraft().font, formattedcharsequence, 30, textY, 0xFFFFFF | color, false);
                textY += 9;
            }
        }
        guiGraphics.renderFakeItem(this.icon, 8, 8);
        return (double)timeSinceLastVisible >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

